/*
 * Decompiled with CFR 0.152.
 */
package cKeyboard;

import cKeyboard.Key;
import cKeyboard.Keyboard;

class BopomoKeyboard
extends Keyboard {
    private static final String qwertyStr = "`1234567890-=qwertyuiop[]asdfghjkl;'zxcvbnm,./~!@#$%^&*()_+QWERTYUIOP{}ASDFGHJKL:\"ZXCVBNM<>?";
    private static final String dvorakStr = "`1234567890[]',.pyfgcrl/=aoeuidhtns-;qjkxbmwvz~!@#$%^&*(){}\"<>PYFGCRL?+AOEUIDHTNS_:QJKXBMWVZ";
    private static final String bopomoStr = "`\u3105\u3109\u02c7\u02cb\u3113\u02ca\u02d9\u311a\u311e\u3122\u3126=\u3106\u310a\u310d\u3110\u3114\u3117\u3127\u311b\u311f\u3123[]\u3107\u310b\u310e\u3111\u3115\u3118\u3128\u311c\u3120\u3124'\u3108\u310c\u310f\u3112\u3116\u3119\u3129\u311d\u3121\u3125`\u3105\u3109\u02c7\u02cb\u3113\u02ca\u02d9\u311a\u311e\u3122\u3126+\u3106\u310a\u310d\u3110\u3114\u3117\u3127\u311b\u311f\u3123{}\u3107\u310b\u310e\u3111\u3115\u3118\u3128\u311c\u3120\u3124\"\u3108\u310c\u310f\u3112\u3116\u3119\u3129\u311d\u3121\u3125";
    private static final int strLen = "`1234567890-=qwertyuiop[]asdfghjkl;'zxcvbnm,./~!@#$%^&*()_+QWERTYUIOP{}ASDFGHJKL:\"ZXCVBNM<>?".length();

    protected BopomoKeyboard(int MaxNumber, String fileBase, String imageBase, boolean isTransfer) {
        super(MaxNumber, fileBase, imageBase, isTransfer);
    }

    @Override
    protected void extendFileBase() {
        this.fileBase = String.valueOf(this.fileBase) + "bo/";
    }

    @Override
    protected void setLimit() {
        this.limit = 128;
    }

    @Override
    protected void createKeyboard() {
        this.button = new Key[58];
        this.button[0] = new Key(0, 50, 50, 50, "`", "~", 5);
        this.button[1] = new Key(50, 50, 50, 50, "\u3105", "invalid", 5);
        this.button[2] = new Key(100, 50, 50, 50, "\u3109", "invalid", 4);
        this.button[3] = new Key(150, 50, 50, 50, "\u02c7", "invalid", 3);
        this.button[4] = new Key(200, 50, 50, 50, "\u02cb", "invalid", 2);
        this.button[5] = new Key(250, 50, 50, 50, "\u3113", "invalid", 2);
        this.button[6] = new Key(300, 50, 50, 50, "\u02ca", "invalid", 8);
        this.button[7] = new Key(350, 50, 50, 50, "\u02d9", "invalid", 8);
        this.button[8] = new Key(400, 50, 50, 50, "\u311a", "invalid", 9);
        this.button[9] = new Key(450, 50, 50, 50, "\u311e", "invalid", 10);
        this.button[10] = new Key(500, 50, 50, 50, "\u3122", "invalid", 11);
        this.button[11] = new Key(550, 50, 50, 50, "\u3126", "invalid", 11);
        this.button[12] = new Key(600, 50, 50, 50, "=", "+", 11);
        this.button[13] = new Key(650, 50, 100, 50, "Backspace", "invalid", 11);
        this.button[14] = new Key(0, 100, 75, 50, "Tab", "invalid", 5);
        this.button[15] = new Key(75, 100, 50, 50, "\u3106", "invalid", 5);
        this.button[16] = new Key(125, 100, 50, 50, "\u310a", "invalid", 4);
        this.button[17] = new Key(175, 100, 50, 50, "\u310d", "invalid", 3);
        this.button[18] = new Key(225, 100, 50, 50, "\u3110", "invalid", 2);
        this.button[19] = new Key(275, 100, 50, 50, "\u3114", "invalid", 2);
        this.button[20] = new Key(325, 100, 50, 50, "\u3117", "invalid", 8);
        this.button[21] = new Key(375, 100, 50, 50, "\u3127", "invalid", 8);
        this.button[22] = new Key(425, 100, 50, 50, "\u311b", "invalid", 9);
        this.button[23] = new Key(475, 100, 50, 50, "\u311f", "invalid", 10);
        this.button[24] = new Key(525, 100, 50, 50, "\u3123", "invalid", 11);
        this.button[25] = new Key(575, 100, 50, 50, "[", "{", 11);
        this.button[26] = new Key(625, 100, 50, 50, "]", "}", 11);
        this.button[27] = new Key(675, 100, 75, 50, "\\", "|", 11);
        this.button[28] = new Key(0, 150, 90, 50, "CapsLock", "invalid", 5);
        this.button[29] = new Key(90, 150, 50, 50, "\u3107", "invalid", 5);
        this.button[30] = new Key(140, 150, 50, 50, "\u310b", "invalid", 4);
        this.button[31] = new Key(190, 150, 50, 50, "\u310e", "invalid", 3);
        this.button[32] = new Key(240, 150, 50, 50, "\u3111", "invalid", 2);
        this.button[33] = new Key(290, 150, 50, 50, "\u3115", "invalid", 2);
        this.button[34] = new Key(340, 150, 50, 50, "\u3118", "invalid", 8);
        this.button[35] = new Key(390, 150, 50, 50, "\u3128", "invalid", 8);
        this.button[36] = new Key(440, 150, 50, 50, "\u311c", "invalid", 9);
        this.button[37] = new Key(490, 150, 50, 50, "\u3120", "invalid", 10);
        this.button[38] = new Key(540, 150, 50, 50, "\u3124", "invalid", 11);
        this.button[39] = new Key(590, 150, 50, 50, "'", "\"", 11);
        this.button[40] = new Key(640, 150, 110, 50, "Enter", "invalid", 11);
        this.button[41] = new Key(0, 200, 100, 50, "Shift", "invalid", 5);
        this.button[42] = new Key(100, 200, 50, 50, "\u3108", "invalid", 5);
        this.button[43] = new Key(150, 200, 50, 50, "\u310c", "invalid", 4);
        this.button[44] = new Key(200, 200, 50, 50, "\u310f", "invalid", 3);
        this.button[45] = new Key(250, 200, 50, 50, "\u3112", "invalid", 2);
        this.button[46] = new Key(300, 200, 50, 50, "\u3116", "invalid", 2);
        this.button[47] = new Key(350, 200, 50, 50, "\u3119", "invalid", 8);
        this.button[48] = new Key(400, 200, 50, 50, "\u3129", "invalid", 8);
        this.button[49] = new Key(450, 200, 50, 50, "\u311d", "invalid", 9);
        this.button[50] = new Key(500, 200, 50, 50, "\u3121", "invalid", 10);
        this.button[51] = new Key(550, 200, 50, 50, "\u3125", "invalid", 11);
        this.button[52] = new Key(600, 200, 150, 50, "Shift", "invalid", 11);
        this.button[53] = new Key(0, 250, 75, 50, "Ctrl", "invalid", 5);
        this.button[54] = new Key(140, 250, 60, 50, "Alt", "invalid", 5);
        this.button[55] = new Key(200, 250, 290, 50, " ", "invalid", 1);
        this.button[56] = new Key(490, 250, 60, 50, "Alt", "invalid", 9);
        this.button[57] = new Key(675, 250, 75, 50, "Ctrl", "invalid", 11);
    }

    @Override
    protected String dispatch(String c) {
        if (this.isTransfer) {
            return BopomoKeyboard.DvorakToBopomo(c);
        }
        return BopomoKeyboard.QwertyToBopomo(c);
    }

    private static String DvorakToBopomo(String c) {
        String text = "";
        int i = 0;
        while (i < c.length()) {
            boolean found = false;
            int j = 0;
            while (j < strLen) {
                if (c.charAt(i) == dvorakStr.charAt(j)) {
                    text = String.valueOf(text) + bopomoStr.charAt(j);
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                text = String.valueOf(text) + c.charAt(i);
            }
            ++i;
        }
        return text;
    }

    private static String QwertyToBopomo(String c) {
        String text = "";
        int i = 0;
        while (i < c.length()) {
            boolean found = false;
            int j = 0;
            while (j < strLen) {
                if (c.charAt(i) == qwertyStr.charAt(j)) {
                    text = String.valueOf(text) + bopomoStr.charAt(j);
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                text = String.valueOf(text) + c.charAt(i);
            }
            ++i;
        }
        return text;
    }
}

