/*
 * Decompiled with CFR 0.152.
 */
package cKeyboard;

import cDialog.ResultDialog;
import cDialog.SelectDialog;
import cKeyboard.Key;
import dataTools.Base;
import dataTools.DataScanner;
import dataTools.DataTrans;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JPanel;
import javax.swing.Timer;

public abstract class Keyboard
extends JPanel
implements KeyListener,
ActionListener {
    protected Color sColor = new Color(0, 136, 0);
    protected Color rColor = new Color(70, 105, 0);
    protected Color cColor = new Color(110, 165, 0);
    protected Color bkColor = new Color(253, 255, 230);
    protected Font kFont = new Font("Keyboard", 0, 15);
    protected Font tFont = new Font("Timer", 0, 24);
    protected Font cFont = new Font("Chinese", 0, 36);
    protected String fileBase;
    protected String ImageBase;
    protected int limit;
    private int MaxNumber;
    protected Graphics2D desk;
    protected Image[] lfingure;
    protected Image[] rfingure;
    protected int nowFingure;
    protected Timer timer;
    protected int timeLength;
    protected int remainTime;
    protected Key[] button;
    protected int nowKey;
    protected static final int NONE = -1;
    protected static int MAXWORD = 16;
    protected String[] chinese;
    protected String[] pronounce;
    protected int number;
    protected int nowWord;
    protected int nowPSym;
    protected int pSymLen;
    protected int tempP;
    protected boolean isTransfer;
    private Status status;

    protected Keyboard(int MaxNumber, String fileBase, String imageBase, boolean isTransfer) {
        this.MaxNumber = MaxNumber;
        this.fileBase = fileBase;
        this.isTransfer = isTransfer;
        Key.readImage(imageBase);
        this.createKeyboard();
        this.extendFileBase();
        this.setLimit();
        this.timeLength = 36;
        this.timer = new Timer(1000, this);
        this.nowKey = 0;
        this.nowFingure = 0;
    }

    protected void selectDialog() {
        SelectDialog dialog = new SelectDialog(this, this.MaxNumber, this.limit);
    }

    protected void createKeyboard() {
    }

    protected void extendFileBase() {
        this.fileBase = String.valueOf(this.fileBase);
    }

    protected void setLimit() {
        this.limit = 0;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.bkColor);
        g.fillRect(0, 0, 780, 420);
        g.setColor(this.rColor);
        int i = 0;
        while (i < 5) {
            g.drawRect(i, i, 780 - 2 * i, 420 - 2 * i);
            ++i;
        }
        i = 1;
        while (i < 5) {
            g.drawRect(10 + i, 55 + i, 759 - 2 * i, 329 - 2 * i);
            ++i;
        }
        i = 0;
        while (i < this.button.length) {
            this.button[i].paintKey(g);
            ++i;
        }
        this.button[this.nowKey].paintFingure(g);
        this.drawNumber(g);
        this.drawText(g);
        this.drawCaret(g);
        this.drawClock(g, true);
    }

    private void drawText(Graphics g) {
        int p;
        Graphics display = g.create(5, 5, 770, 50);
        display.setColor(this.bkColor);
        display.fillRect(78, 0, 600, 50);
        display.setColor(this.sColor);
        display.setFont(this.cFont);
        int start = this.nowWord / 4;
        int end = (start *= 4) + 4;
        int i = start;
        while (i < end) {
            p = 78 + 156 * (i % 4);
            display.drawString(this.chinese[i], p, 43);
            ++i;
        }
        display.setFont(this.kFont);
        i = start;
        while (i < end) {
            p = 114 + 156 * (i % 4) + (120 - this.pronounce[i].length() * 15) / 2;
            int pl = this.pronounce[i].length();
            int j = 0;
            while (j < pl) {
                display.drawString(this.pronounce[i].substring(j, j + 1), p + 15 * j, 34);
                ++j;
            }
            ++i;
        }
    }

    private void drawCaret(Graphics g) {
        Graphics display = g.create(5, 5, 770, 50);
        int p = 114 + 156 * (this.nowWord % 4);
        p = p + (120 - 15 * this.pronounce[this.nowWord].length()) / 2 + this.nowPSym * 15;
        display.setColor(this.bkColor);
        display.fillRect(this.tempP, 39, 16, 3);
        display.setColor(this.rColor);
        display.drawLine(p, 39, p + 15, 39);
        display.drawLine(p, 40, p + 15, 40);
        display.drawLine(p, 41, p + 15, 41);
        display.setColor(this.sColor);
        this.tempP = p;
    }

    protected void drawClock(Graphics g, boolean repaint) {
        Graphics display = g.create(5, 5, 770, 50);
        display.setFont(this.kFont);
        Graphics clock = g.create(675, 315, 100, 100);
        if (repaint) {
            clock.setColor(this.cColor);
            clock.fillOval(1, 1, 98, 98);
            clock.setColor(Color.white);
            clock.fillOval(7, 7, 86, 86);
            clock.setColor(this.rColor);
            clock.fillArc(6, 6, 88, 88, 90, (this.remainTime - this.timeLength) * 10);
        } else if (this.remainTime > 0) {
            clock.setColor(this.rColor);
            clock.fillArc(6, 6, 88, 88, 90 + (this.remainTime - this.timeLength) * 10, 10);
        }
        display.setColor(this.bkColor);
        display.fillRect(722, 0, 40, 50);
        display.setColor(this.sColor);
        display.setFont(this.tFont);
        if (this.remainTime > 99) {
            display.drawString(Integer.toString(this.remainTime), 722, 30);
        } else if (this.remainTime > 9) {
            display.drawString(Integer.toString(this.remainTime), 734, 30);
        } else {
            display.drawString(Integer.toString(this.remainTime), 746, 30);
        }
    }

    public void drawNumber(Graphics g) {
        Graphics display = g.create(5, 5, 770, 50);
        display.setColor(this.bkColor);
        display.fillRect(0, 0, 700, 50);
        display.setColor(this.sColor);
        display.setFont(new Font("Number", 0, 24));
        display.drawString(Integer.toString(this.number), 12, 30);
        display.setFont(this.kFont);
        display.drawString("930702", 12, 50);
    }

    public void prepare(int lessonNum) {
        this.status = Status.Stop;
        this.remainTime = this.timeLength;
        this.number = lessonNum;
        this.readLesson(lessonNum);
        this.nowWord = 0;
        this.nowPSym = 0;
        this.setKey(this.pronounce[this.nowWord].substring(this.nowPSym, this.nowPSym + 1));
        this.pSymLen = this.pronounce[this.nowWord].length();
        this.tempP = 159;
    }

    protected void readLesson(int lessonNum) {
        int head;
        lessonNum = lessonNum < this.limit ? lessonNum : this.limit;
        lessonNum = lessonNum > 1 ? lessonNum : 1;
        String fileName = "";
        fileName = lessonNum > 99 ? String.valueOf(fileName) + lessonNum : (lessonNum > 9 ? String.valueOf(fileName) + "0" + lessonNum : String.valueOf(fileName) + "00" + lessonNum);
        String text = DataScanner.readText(this.fileBase, fileName);
        this.chinese = new String[MAXWORD];
        this.pronounce = new String[MAXWORD];
        int tail = head = 0;
        int i = 0;
        while (i < MAXWORD) {
            tail = text.indexOf(DataScanner.Enter, tail);
            this.chinese[i] = text.substring(head, tail);
            head = ++tail;
            tail = text.indexOf(DataScanner.Enter, tail);
            this.pronounce[i] = text.substring(head, tail);
            head = ++tail;
            ++i;
        }
    }

    protected void start() {
        this.timer.start();
        this.status = Status.Start;
    }

    protected void sendData() {
        try {
            DataTrans dataTrans = new DataTrans("tSumURL");
            dataTrans.connect();
            dataTrans.openOut();
            dataTrans.write("&examCode=T23");
            dataTrans.write("&status=W");
            dataTrans.write("&user=" + Base.user);
            dataTrans.write("&time=" + Integer.toString(this.timeLength - this.remainTime));
            dataTrans.write("&prob=" + Integer.toString(this.number));
            dataTrans.write("&type=4");
            dataTrans.closeOut();
            dataTrans.POSTfinshOut();
        }
        catch (Exception e) {
            System.out.print("connect error!");
        }
    }

    protected void finish() {
        this.timer.stop();
        this.status = Status.Finsh;
        this.sendData();
        int CPM = 0;
        if (this.remainTime > 0) {
            CPM = 60 / (this.timeLength - this.remainTime) * MAXWORD;
        }
        if (this.remainTime > 0) {
            this.MaxNumber = Math.max(this.number + 1, this.MaxNumber);
            ResultDialog resultDialog = new ResultDialog(this, this.number, CPM, true);
        } else {
            ResultDialog resultDialog = new ResultDialog(this, this.number, CPM, false);
        }
    }

    public void repeatLesson() {
        this.prepare(this.number);
    }

    public void nextLesson() {
        this.prepare(++this.number);
    }

    public void previousLesson() {
        this.prepare(--this.number);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        String c = Character.toString(e.getKeyChar());
        this.testKey(c);
    }

    protected String dispatch(String c) {
        return c;
    }

    protected void testKey(String c) {
        if (this.status == Status.Stop) {
            this.start();
        }
        if (this.status != Status.Start) {
            return;
        }
        if (!(c = this.dispatch(c)).equalsIgnoreCase(this.pronounce[this.nowWord].substring(this.nowPSym, this.nowPSym + 1))) {
            return;
        }
        if (this.nowPSym + 1 != this.pSymLen) {
            ++this.nowPSym;
            this.setKey(this.pronounce[this.nowWord].substring(this.nowPSym, this.nowPSym + 1));
            this.drawCaret(this.getGraphics());
            return;
        }
        if (this.nowWord + 1 != MAXWORD) {
            ++this.nowWord;
            this.nowPSym = 0;
            this.pSymLen = this.pronounce[this.nowWord].length();
            this.setKey(this.pronounce[this.nowWord].substring(this.nowPSym, this.nowPSym + 1));
            this.drawText(this.getGraphics());
            this.drawCaret(this.getGraphics());
            return;
        }
        this.finish();
    }

    protected void setKey(String c) {
        Graphics g = this.getGraphics();
        int nextKey = this.findKey(c);
        if (nextKey == this.nowKey) {
            return;
        }
        this.button[this.nowKey].delNext();
        this.button[this.nowKey].paintKey(g);
        this.button[nextKey].setNext();
        this.button[nextKey].paintKey(g);
        this.nowKey = nextKey;
        int nextFingure = this.button[nextKey].getFingure();
        if (nextFingure == this.nowFingure) {
            return;
        }
        this.button[nextKey].paintFingure(g);
        this.nowFingure = nextFingure;
    }

    protected int findKey(String c) {
        int i = 0;
        while (i < 58) {
            if (c.equalsIgnoreCase(this.button[i].getMaster())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.remainTime > 0) {
            --this.remainTime;
            this.drawClock(this.getGraphics(), false);
        } else {
            this.timer.stop();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private static enum Status {
        Stop,
        Start,
        Finsh;

    }
}

