/*
 * Decompiled with CFR 0.152.
 */
package cTest;

import cTest.TopicPanel;
import dataTools.Base;
import dataTools.DataScanner;
import dataTools.DataTrans;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

class CTest
extends JPanel
implements CaretListener,
KeyListener {
    private String etype;
    private String fileBase;
    private String fileName;
    private int inputRowSize = 8;
    private int inputColSize = 27;
    private int fontSize = 20;
    private long startTime;
    private long timeLength;
    private JTextArea inputArea;
    private TopicPanel topicPanel;
    private Status status;

    public CTest(String etype, String fileBase, String fileName) {
        this.etype = etype;
        this.fileBase = fileBase;
        this.fileName = fileName;
        this.status = Status.Stop;
        this.topicPanel = new TopicPanel(DataScanner.readText(fileBase, fileName), this.fontSize);
        this.topicPanel.setBackground(new Color(0, 187, 0));
        this.inputArea = new JTextArea(this.inputRowSize, this.inputColSize);
        this.inputArea.setFont(new Font("\u65b0\u7d30\u660e\u9ad4", 0, this.fontSize));
        this.inputArea.setMargin(new Insets(0, 10, 0, 0));
        this.inputArea.addCaretListener(this);
        this.inputArea.addKeyListener(this);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.topicPanel, "Center");
        this.add((Component)new JScrollPane(this.inputArea), "South");
    }

    private void finish() {
        block8: {
            this.inputArea.setEditable(false);
            this.inputArea.setBackground(Color.gray);
            if (this.status != Status.F12 && this.status != Status.Finish) {
                return;
            }
            this.timeLength = System.currentTimeMillis() - this.startTime;
            this.timeLength /= 1000L;
            this.timeLength = this.timeLength >= 3600L ? 3600L : this.timeLength;
            int inputCount = this.topicPanel.getInputCounter();
            int correctCount = this.topicPanel.getCorrectCounter();
            float accuracy = correctCount * 100 / inputCount;
            String scoreMsg = "";
            long score = 0L;
            if (inputCount < 150 || accuracy < 90.0f) {
                score = 0L;
                scoreMsg = "\u8f38\u5165\u5b57\u6578\u6216\u6b63\u78ba\u7387\u672a\u9054\u6a19\u6e96\u3002";
            } else {
                score = (long)(correctCount * 60) / this.timeLength;
                scoreMsg = score + " \uff23\uff30\uff2d";
            }
            if (score > 159L && this.etype == "E") {
                JOptionPane.showMessageDialog(null, new JLabel("<html><h2>\u60a8\u7684\u6210\u7e3e\u975e\u51e1\u4eba\u6240\u80fd\uff0c\u8acb\u5c07\u87a2\u5e55\u62cd\u7167\u6216\u8005\u64f7\u5716\u5b58\u8b49\uff0c</h2><h2>\u62ff\u53bb\u627e\u6388\u8ab2\u6559\u5e2b\u6216 bcc16 \u7db2\u7ba1\uff0c\u8acb\u4ed6/\u5979\u9a57\u8b49\u4e4b\u5f8c\u5e6b\u60a8\u767b\u8a18\u6210\u7e3e\u3002</h2><h2>\u6b64\u4efd\u6210\u7e3e\u66ab\u6642\u4e26\u672a\u767b\u8a18\u3002</h2><h2>\u8f38\u5165\u5b57\u6578\uff1a" + inputCount + "</h2>" + "<h2>" + "\u6b63\u78ba\u5b57\u6578\uff1a" + correctCount + "</h2>" + "<h2>" + "\u932f\u8aa4\u5b57\u6578\uff1a" + (inputCount - correctCount) + "</h2>" + "<h2>" + "\u6b63\u3000\u78ba\u3000\u7387\uff1a" + accuracy + " \uff05</h2>" + "<h2>" + "\u6642\u3000\u3000\u9593\uff1a" + this.timeLength / 60L + " \u5206 " + this.timeLength % 60L + " \u79d2</h2>" + "<h2>" + "\u6210\u3000\u3000\u7e3e\uff1a" + scoreMsg + "</h2>" + "<h2> \u4f7f\u3000\u7528\u3000\u8005\uff1a " + Base.name + "</h2>" + "</html>"));
                score = -1L;
            } else {
                JOptionPane.showMessageDialog(null, "\u8f38\u5165\u5b57\u6578\uff1a" + inputCount + "\n" + "\u6b63\u78ba\u5b57\u6578\uff1a" + correctCount + "\n" + "\u932f\u8aa4\u5b57\u6578\uff1a" + (inputCount - correctCount) + "\n" + "\u6b63\u78ba\u7387\u3000\uff1a" + accuracy + " \uff05\n" + "\u6642\u3000\u3000\u9593\uff1a" + this.timeLength / 60L + " \u5206 " + this.timeLength % 60L + " \u79d2\n" + "\u6210\u3000\u3000\u7e3e\uff1a" + scoreMsg);
            }
            if (inputCount >= 150 && accuracy >= 90.0f) {
                try {
                    DataTrans dataTrans = new DataTrans("tSumURL");
                    dataTrans.connect();
                    dataTrans.openOut();
                    dataTrans.write("&examCode=T21");
                    dataTrans.write("&status=W");
                    dataTrans.write("&user=" + Base.user);
                    dataTrans.write("&type=" + this.etype);
                    dataTrans.write("&score=" + score);
                    dataTrans.write("&time=" + this.timeLength);
                    dataTrans.closeOut();
                    dataTrans.POSTfinshOut();
                }
                catch (Exception e) {
                    System.out.print(456);
                    if (this.etype != "E") break block8;
                    JOptionPane.showMessageDialog(null, new JLabel("<html><h2>\u9023\u7dda\u932f\u8aa4\uff0c\u8acb\u5c07\u87a2\u5e55\u62cd\u7167\u6216\u8005\u64f7\u5716\u5b58\u8b49\uff0c</h2><h2>\u62ff\u53bb\u627e\u6388\u8ab2\u6559\u5e2b\u6216 bcc16 \u7db2\u7ba1\uff0c\u8acb\u4ed6/\u5979\u5e6b\u60a8\u767b\u8a18\u6210\u7e3e\u3002</h2><h2>\u6b64\u4efd\u6210\u7e3e\u66ab\u6642\u4e26\u672a\u767b\u8a18\u3002</h2><h2>\u8f38\u5165\u5b57\u6578\uff1a" + inputCount + "</h2>" + "<h2>" + "\u6b63\u78ba\u5b57\u6578\uff1a" + correctCount + "</h2>" + "<h2>" + "\u932f\u8aa4\u5b57\u6578\uff1a" + (inputCount - correctCount) + "</h2>" + "<h2>" + "\u6b63\u3000\u78ba\u3000\u7387\uff1a" + accuracy + " \uff05</h2>" + "<h2>" + "\u6642\u3000\u3000\u9593\uff1a" + this.timeLength / 60L + " \u5206 " + this.timeLength % 60L + " \u79d2</h2>" + "<h2>" + "\u6210\u3000\u3000\u7e3e\uff1a" + scoreMsg + "</h2>" + "<h2> \u4f7f\u3000\u7528\u3000\u8005\uff1a " + Base.name + "</h2>" + "</html>"));
                }
            }
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (this.status != Status.Start) {
            if (this.inputArea.getCaretPosition() > 0) {
                this.startTime = System.currentTimeMillis();
                this.status = Status.Start;
            } else {
                return;
            }
        }
        try {
            this.topicPanel.updateEcho(this.inputArea.getText());
            this.topicPanel.centerScreen(this.inputArea.getCaretPosition());
            System.out.println("hi");
        }
        catch (Exception e1) {
            this.status = Status.Finish;
            this.finish();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 86 && e.getModifiers() == 2) {
            JOptionPane.showMessageDialog(null, "\u60a8\u4f7f\u7528\u4e86 paste \u529f\u80fd\uff0c\u6e2c\u9a57\u7d42\u6b62\u3002");
            this.status = Status.Cheat;
            this.inputArea.setText("");
            this.finish();
        }
        if (e.getKeyCode() == 123 && this.status == Status.Start) {
            this.status = Status.F12;
            this.finish();
        }
        if (e.getKeyCode() == 27 && this.status == Status.Start) {
            JOptionPane.showMessageDialog(null, "\u6e2c\u9a57\u7d42\u6b62\u3002");
            this.status = Status.Esc;
            this.finish();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private static enum Status {
        Stop,
        Start,
        Esc,
        F12,
        Cheat,
        Finish;

    }
}

