/*
 * Decompiled with CFR 0.152.
 */
package cTest;

import dataTools.DataScanner;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JPanel;

class TopicPanel
extends JPanel {
    private String text;
    private String echo;
    private int head;
    private int linesAmount = 8;
    private int[] rowsIndex;
    private int totalLines;
    private Font font;
    private int fontSize;

    public TopicPanel(String text, int fontSize) {
        this.text = text;
        this.fontSize = fontSize;
        this.font = new Font("\u65b0\u7d30\u660e\u9ad4", 0, fontSize);
        this.head = 0;
        this.echo = "";
        this.initLineInfo();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setFont(this.font);
        int pos = this.head;
        int row = 0;
        while (row < this.linesAmount && pos < this.text.length()) {
            int col = 0;
            while (true) {
                g.drawString("" + this.text.charAt(pos), 10 + this.fontSize * col, 20 + this.fontSize * row);
                if (pos < this.echo.length() && this.text.charAt(pos) != this.echo.charAt(pos)) {
                    g.setColor(Color.red);
                    g.drawRect(10 + this.fontSize * col, 4 + this.fontSize * row, this.fontSize, this.fontSize);
                    g.setColor(Color.black);
                }
                if (this.text.charAt(pos) == DataScanner.cEnter) {
                    ++pos;
                    break;
                }
                ++col;
                ++pos;
            }
            ++row;
        }
    }

    private void initLineInfo() {
        int row = 0;
        int[] rowsIndex = new int[1000];
        rowsIndex[0] = 0;
        int pos = 0;
        while (pos < this.text.length()) {
            if (this.text.charAt(pos) == DataScanner.cEnter) {
                rowsIndex[++row] = pos + 1;
            }
            ++pos;
        }
        this.totalLines = row;
        this.rowsIndex = new int[row];
        int i = 0;
        while (i < this.totalLines) {
            this.rowsIndex[i] = rowsIndex[i];
            ++i;
        }
    }

    public int getInputCounter() {
        return this.echo.length();
    }

    public int getCorrectCounter() {
        int counter = 0;
        int i = 0;
        while (i < this.echo.length()) {
            if (this.echo.charAt(i) == this.text.charAt(i)) {
                ++counter;
            }
            ++i;
        }
        return counter;
    }

    public void updateEcho(String newEcho) throws Exception {
        if (newEcho.length() >= this.text.length()) {
            throw new Exception();
        }
        this.echo = newEcho;
        this.repaint();
    }

    public void centerScreen(int caretPos) {
        int row = 0;
        while (row < this.totalLines) {
            if (caretPos < this.rowsIndex[row]) break;
            ++row;
        }
        int headrow = row - 6 > 0 ? row - 6 : 0;
        row = 0;
        int pos = 0;
        while (pos < this.echo.length()) {
            if (this.echo.charAt(pos) == '\n') {
                ++row;
            }
            ++pos;
        }
        headrow = row - 3 > headrow ? row - 3 : headrow;
        this.head = 0;
        int i = 0;
        while (i < headrow) {
            this.head = this.text.indexOf(DataScanner.Enter, this.head + 1);
            ++this.head;
            ++i;
        }
    }
}

