/*
 * Decompiled with CFR 0.152.
 */
package crypto;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class Crypto
extends JPanel {
    private JLabel desCiphertextLabel;
    private JTextField desCiphertextTextField;
    private JButton desDecryptButton;
    private JLabel desDecryptKeyLabel;
    private JTextField desDecryptKeyTextField;
    private JTextField desDecryptedTextField;
    private JButton desEncryptButton;
    private JLabel desEncryptKeyLabel;
    private JTextField desEncryptKeyTextField;
    private JTextField desEncryptedTextField;
    private JPanel desPanel;
    private JLabel desPlaintextLabel;
    private JTextField desPlaintextTextField;
    private JSeparator desSeparator;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTabbedPane jTabbedPane1;
    private JTextField rsaCPTextField;
    private JTextField rsaCTextField;
    private JTextField rsaDTextField;
    private JButton rsaDecryptButton;
    private JTextField rsaETextField;
    private JButton rsaEncryptButton;
    private JButton rsaGenkeyButton;
    private JTextField rsaMPTextField;
    private JTextField rsaMTextField;
    private JTextField rsaNTextField;
    private JTextField rsaPTextField;
    private JPanel rsaPanel;
    private JTextField rsaQTextField;

    public Crypto() {
        this.initComponents();
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.desPanel = new JPanel();
        this.desPlaintextLabel = new JLabel();
        this.desPlaintextTextField = new JTextField();
        this.desEncryptKeyLabel = new JLabel();
        this.desEncryptKeyTextField = new JTextField();
        this.desEncryptButton = new JButton();
        this.desEncryptedTextField = new JTextField();
        this.desCiphertextLabel = new JLabel();
        this.desCiphertextTextField = new JTextField();
        this.desDecryptKeyLabel = new JLabel();
        this.desDecryptKeyTextField = new JTextField();
        this.desDecryptButton = new JButton();
        this.desDecryptedTextField = new JTextField();
        this.desSeparator = new JSeparator();
        this.rsaPanel = new JPanel();
        this.rsaGenkeyButton = new JButton();
        this.jLabel1 = new JLabel();
        this.rsaPTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.rsaQTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.rsaNTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.rsaETextField = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.rsaDTextField = new JTextField();
        this.jLabel8 = new JLabel();
        this.jLabel5 = new JLabel();
        this.rsaMTextField = new JTextField();
        this.rsaEncryptButton = new JButton();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.rsaCPTextField = new JTextField();
        this.jLabel11 = new JLabel();
        this.rsaDecryptButton = new JButton();
        this.jLabel12 = new JLabel();
        this.rsaCTextField = new JTextField();
        this.jLabel13 = new JLabel();
        this.rsaMPTextField = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.desPlaintextLabel.setText("\u660e\u6587");
        this.desEncryptKeyLabel.setText("\u91d1\u9470");
        this.desEncryptButton.setText("\u52a0\u5bc6");
        this.desEncryptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Crypto.this.desEncryptButtonActionPerformed(evt);
            }
        });
        this.desEncryptedTextField.setEditable(false);
        this.desCiphertextLabel.setText("\u5bc6\u6587");
        this.desDecryptKeyLabel.setText("\u91d1\u9470");
        this.desDecryptButton.setText("\u89e3\u5bc6");
        this.desDecryptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Crypto.this.desDecryptButtonActionPerformed(evt);
            }
        });
        this.desDecryptedTextField.setEditable(false);
        GroupLayout desPanelLayout = new GroupLayout(this.desPanel);
        this.desPanel.setLayout(desPanelLayout);
        desPanelLayout.setHorizontalGroup(desPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(desPanelLayout.createSequentialGroup().addGroup(desPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(desPanelLayout.createSequentialGroup().addGap(32, 32, 32).addGroup(desPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.desPlaintextLabel).addComponent(this.desEncryptKeyLabel).addComponent(this.desEncryptButton).addComponent(this.desCiphertextLabel).addComponent(this.desDecryptKeyLabel).addComponent(this.desDecryptButton)).addGap(25, 25, 25).addGroup(desPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.desDecryptedTextField).addComponent(this.desDecryptKeyTextField).addComponent(this.desCiphertextTextField).addComponent(this.desEncryptKeyTextField).addComponent(this.desEncryptedTextField).addComponent(this.desPlaintextTextField, -2, 254, -2))).addGroup(desPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.desSeparator, -1, 608, Short.MAX_VALUE))).addContainerGap()));
        desPanelLayout.setVerticalGroup(desPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(desPanelLayout.createSequentialGroup().addGap(23, 23, 23).addGroup(desPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.desPlaintextLabel).addComponent(this.desPlaintextTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(desPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.desEncryptKeyLabel).addComponent(this.desEncryptKeyTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(desPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.desEncryptButton).addComponent(this.desEncryptedTextField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.desSeparator, -2, 10, -2).addGap(20, 20, 20).addGroup(desPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.desCiphertextLabel).addComponent(this.desCiphertextTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(desPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.desDecryptKeyLabel).addComponent(this.desDecryptKeyTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(desPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.desDecryptButton).addComponent(this.desDecryptedTextField, -2, -1, -2)).addContainerGap(69, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("\u5c0d\u7a31\u5f0f\u5bc6\u78bc", this.desPanel);
        this.rsaPanel.setPreferredSize(new Dimension(592, 362));
        this.rsaGenkeyButton.setText("\u7522\u751f\u91d1\u9470");
        this.rsaGenkeyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Crypto.this.rsaGenkeyButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("prime p =");
        this.rsaPTextField.setEditable(false);
        this.jLabel2.setText("prime q =");
        this.rsaQTextField.setEditable(false);
        this.jLabel3.setText("n = p * q =");
        this.rsaNTextField.setEditable(false);
        this.jLabel4.setText("e =");
        this.rsaETextField.setEditable(false);
        this.jLabel6.setText("1 < e < \u03c6(pq) and e, \u03c6(pq) are coprime");
        this.jLabel7.setText("d =");
        this.rsaDTextField.setEditable(false);
        this.jLabel8.setText("d * e = 1 mod \u03c6(pq)");
        this.jLabel5.setText("\u660e\u6587 m =");
        this.rsaEncryptButton.setText("\u52a0\u5bc6");
        this.rsaEncryptButton.setEnabled(false);
        this.rsaEncryptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Crypto.this.rsaEncryptButtonActionPerformed(evt);
            }
        });
        this.jLabel9.setText("\u5bc6\u6587 c = m^e mod n =");
        this.jLabel10.setText("\u4ee5 public key (n, e) \u52a0\u5bc6");
        this.rsaCPTextField.setEditable(false);
        this.jLabel11.setText("\u4ee5 private key (n, d) \u89e3\u5bc6");
        this.rsaDecryptButton.setText("\u89e3\u5bc6");
        this.rsaDecryptButton.setEnabled(false);
        this.rsaDecryptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Crypto.this.rsaDecryptButtonActionPerformed(evt);
            }
        });
        this.jLabel12.setText("\u5bc6\u6587 c =");
        this.jLabel13.setText("\u660e\u6587 m = c^d mod n =");
        this.rsaMPTextField.setEditable(false);
        GroupLayout rsaPanelLayout = new GroupLayout(this.rsaPanel);
        this.rsaPanel.setLayout(rsaPanelLayout);
        rsaPanelLayout.setHorizontalGroup(rsaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rsaPanelLayout.createSequentialGroup().addContainerGap().addGroup(rsaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING, -1, 608, Short.MAX_VALUE).addGroup(rsaPanelLayout.createSequentialGroup().addGroup(rsaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rsaGenkeyButton).addGroup(rsaPanelLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.rsaEncryptButton))).addGap(30, 30, 30).addGroup(rsaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rsaPanelLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rsaPTextField, -2, 60, -2).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rsaQTextField, -2, 60, -2)).addGroup(rsaPanelLayout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rsaETextField, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6)).addGroup(rsaPanelLayout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rsaNTextField, -2, 60, -2)).addGroup(rsaPanelLayout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rsaDTextField, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8)).addComponent(this.jLabel10).addGroup(rsaPanelLayout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rsaMTextField, -2, 60, -2).addGap(18, 18, 18).addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rsaCPTextField, -2, 60, -2))).addGap(103, 103, 103)).addComponent(this.jSeparator2, -1, 608, Short.MAX_VALUE).addGroup(rsaPanelLayout.createSequentialGroup().addGap(14, 14, 14).addComponent(this.rsaDecryptButton).addGap(44, 44, 44).addGroup(rsaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel11).addGroup(rsaPanelLayout.createSequentialGroup().addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rsaCTextField, -2, 60, -2).addGap(18, 18, 18).addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rsaMPTextField, -2, 60, -2))).addGap(106, 106, 106))).addContainerGap()));
        rsaPanelLayout.setVerticalGroup(rsaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rsaPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(rsaPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.rsaPTextField, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.rsaQTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(rsaPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.rsaNTextField, -2, -1, -2).addComponent(this.rsaGenkeyButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(rsaPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.rsaETextField, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(rsaPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.rsaDTextField, -2, -1, -2).addComponent(this.jLabel8)).addGap(18, 18, 18).addComponent(this.jSeparator1, -2, 10, -2).addGap(7, 7, 7).addGroup(rsaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rsaPanelLayout.createSequentialGroup().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(rsaPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.rsaMTextField, -2, -1, -2).addComponent(this.jLabel9).addComponent(this.rsaCPTextField, -2, -1, -2))).addComponent(this.rsaEncryptButton)).addGap(18, 18, 18).addComponent(this.jSeparator2, -2, 10, -2).addGap(18, 18, 18).addGroup(rsaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rsaPanelLayout.createSequentialGroup().addComponent(this.jLabel11).addGap(12, 12, 12).addGroup(rsaPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.rsaCTextField, -2, -1, -2).addComponent(this.jLabel13).addComponent(this.rsaMPTextField, -2, -1, -2))).addComponent(this.rsaDecryptButton)).addGap(89, 89, 89)));
        this.jTabbedPane1.addTab("\u975e\u5c0d\u7a31\u5f0f\u5bc6\u78bc", this.rsaPanel);
        this.add((Component)this.jTabbedPane1, "Center");
    }

    private void rsaDecryptButtonActionPerformed(ActionEvent evt) {
        try {
            BigInteger c = new BigInteger(this.rsaCTextField.getText());
            BigInteger d = new BigInteger(this.rsaDTextField.getText());
            BigInteger n = new BigInteger(this.rsaNTextField.getText());
            BigInteger m = c.modPow(d, n);
            this.rsaMPTextField.setText(m.toString());
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, "\u8f38\u5165\u6578\u5b57\u6709\u8aa4\uff0c\u8acb\u91cd\u65b0\u8f38\u5165\uff01");
            Logger.getLogger(Crypto.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
    }

    private void rsaEncryptButtonActionPerformed(ActionEvent evt) {
        try {
            BigInteger m = new BigInteger(this.rsaMTextField.getText());
            BigInteger e = new BigInteger(this.rsaETextField.getText());
            BigInteger n = new BigInteger(this.rsaNTextField.getText());
            BigInteger c = m.modPow(e, n);
            this.rsaCPTextField.setText(c.toString());
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, "\u8f38\u5165\u6578\u5b57\u6709\u8aa4\uff0c\u8acb\u91cd\u65b0\u8f38\u5165\uff01");
            Logger.getLogger(Crypto.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
    }

    private void rsaGenkeyButtonActionPerformed(ActionEvent evt) {
        int p = this.genRandomPrime(10, 100);
        int q = this.genRandomPrime(10, 100);
        int n = p * q;
        int t = (p - 1) * (q - 1);
        int e = 0;
        int d = 0;
        while (!this.isCoprime(e = this.genRandomInt(2, t), t)) {
        }
        d = 1;
        while (d < t) {
            if (d * e % t == 1) break;
            ++d;
        }
        this.rsaPTextField.setText(Integer.toString(p));
        this.rsaQTextField.setText(Integer.toString(q));
        this.rsaNTextField.setText(Integer.toString(n));
        this.rsaETextField.setText(Integer.toString(e));
        this.rsaDTextField.setText(Integer.toString(d));
        this.rsaEncryptButton.setEnabled(true);
        this.rsaDecryptButton.setEnabled(true);
    }

    private void desDecryptButtonActionPerformed(ActionEvent evt) {
        byte[] input = this.hexStringToBytes(this.desCiphertextTextField.getText());
        if (input == null || input.length % 8 != 0) {
            JOptionPane.showMessageDialog(this, "\u5bc6\u6587\u9577\u5ea6\u6709\u8aa4\uff0c\u8acb\u91cd\u65b0\u8f38\u5165\uff01");
            return;
        }
        byte[] keytmp = this.desDecryptKeyTextField.getText().getBytes();
        byte[] key = new byte[8];
        int i = 0;
        while (i < 8) {
            key[i] = i < keytmp.length ? keytmp[i] : (byte)0;
            ++i;
        }
        byte[] output = this.desCipher(2, key, input);
        if (output == null) {
            JOptionPane.showMessageDialog(this, "\u8f38\u5165\u6587\u5b57\u6709\u8aa4\uff0c\u8acb\u91cd\u65b0\u8f38\u5165\uff01");
        }
        this.desDecryptedTextField.setText(new String(output));
    }

    private void desEncryptButtonActionPerformed(ActionEvent evt) {
        byte[] keytmp = this.desEncryptKeyTextField.getText().getBytes();
        byte[] key = new byte[8];
        int i = 0;
        while (i < 8) {
            key[i] = i < keytmp.length ? keytmp[i] : (byte)0;
            ++i;
        }
        byte[] inputtmp = this.desPlaintextTextField.getText().getBytes();
        int inputLen = inputtmp.length;
        int paddingLen = (inputLen + 7) / 8 * 8;
        byte[] input = new byte[paddingLen];
        int i2 = 0;
        while (i2 < paddingLen) {
            input[i2] = i2 < inputLen ? inputtmp[i2] : (byte)0;
            ++i2;
        }
        byte[] output = this.desCipher(1, key, input);
        if (output == null) {
            JOptionPane.showMessageDialog(this, "\u8f38\u5165\u6587\u5b57\u6709\u8aa4\uff0c\u8acb\u91cd\u65b0\u8f38\u5165\uff01");
        }
        this.desEncryptedTextField.setText(this.bytesToHexString(output));
    }

    private String bytesToHexString(byte[] input) {
        String hex = "0123456789abcdef";
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < input.length) {
            int v = input[i] & 0xFF;
            sb.append(hex.charAt(v >> 4));
            sb.append(hex.charAt(v & 0xF));
            ++i;
        }
        return sb.toString();
    }

    private byte[] hexStringToBytes(String input) {
        int length = input.length();
        if (length % 2 != 0) {
            return null;
        }
        String hex = "0123456789abcdef";
        byte[] output = new byte[length / 2];
        int i = 0;
        while (i < length) {
            int high = hex.indexOf(input.charAt(i));
            int low = hex.indexOf(input.charAt(i + 1));
            output[i / 2] = (byte)(high * 16 + low);
            i += 2;
        }
        return output;
    }

    private byte[] desCipher(int opmode, byte[] key, byte[] input) {
        byte[] output = null;
        try {
            Cipher des = Cipher.getInstance("DES/ECB/NoPadding");
            DESKeySpec ks = new DESKeySpec(key);
            SecretKey sk = SecretKeyFactory.getInstance("DES").generateSecret(ks);
            des.init(opmode, sk);
            output = des.doFinal(input);
        }
        catch (IllegalBlockSizeException ex) {
            Logger.getLogger(Crypto.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (BadPaddingException ex) {
            Logger.getLogger(Crypto.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvalidKeySpecException ex) {
            Logger.getLogger(Crypto.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvalidKeyException ex) {
            Logger.getLogger(Crypto.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(Crypto.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchPaddingException ex) {
            Logger.getLogger(Crypto.class.getName()).log(Level.SEVERE, null, ex);
        }
        return output;
    }

    private boolean isPrime(int n) {
        if (n < 2) {
            return false;
        }
        if (n == 2 || n == 3) {
            return true;
        }
        if (n % 2 == 0) {
            return false;
        }
        int testMax = (int)(Math.sqrt(n) + 1.0);
        int i = 3;
        while (i <= testMax) {
            if (n % i == 0) {
                return false;
            }
            i += 2;
        }
        return true;
    }

    private int gcd(int m, int n) {
        if (n == 0) {
            return m;
        }
        return this.gcd(n, m % n);
    }

    private boolean isCoprime(int m, int n) {
        return this.gcd(m, n) == 1;
    }

    private int genRandomPrime(int begin, int end) {
        int n = 0;
        Random rand = new Random();
        while (!this.isPrime(n = begin + rand.nextInt(end - begin))) {
        }
        return n;
    }

    private int genRandomInt(int begin, int end) {
        Random rand = new Random();
        return begin + rand.nextInt(end - begin);
    }
}

