/*
 * Decompiled with CFR 0.152.
 */
package dataTools;

import dataTools.DataBase;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.net.ssl.HttpsURLConnection;

public class DataScanner {
    private static DataBase dataBase = new DataBase();
    private static char LF = (char)10;
    private static char CR = (char)13;
    public static String MSEnter = "" + CR + LF;
    public static String MacEnter = "" + CR;
    public static String UnixEnter = "" + LF;
    public static String Enter = "\n";
    public static char cEnter = (char)10;

    public static String readText(String BaseName, String fileName) {
        String urlStr = String.valueOf(dataBase.convertRealName(BaseName)) + fileName;
        String text = "";
        try {
            int count;
            URL url = new URL(urlStr);
            InputStream is = url.openStream();
            byte[] buffer = new byte[1000];
            while ((count = is.read(buffer)) > 0) {
                text = String.valueOf(text) + new String(buffer, 0, count, "UTF-8");
            }
            is.close();
            if (text.indexOf(MSEnter) != -1) {
                text = text.replaceAll(MSEnter, Enter);
            } else if (text.indexOf(MacEnter) != -1) {
                text = text.replaceAll(MacEnter, Enter);
            } else if (text.indexOf(UnixEnter) != -1) {
                text = text.replaceAll(UnixEnter, Enter);
            }
        }
        catch (Exception e) {
            System.out.print("read text error!");
        }
        return text;
    }

    public static Image readImage(String baseName, String imageName) {
        String urlStr = String.valueOf(dataBase.convertRealName(baseName)) + imageName;
        BufferedImage image = null;
        try {
            image = ImageIO.read(new URL(urlStr));
        }
        catch (Exception e) {
            System.out.print("read image error!");
        }
        return image;
    }

    public static void readANDcreateFile(String baseName, String fileName, String newFileName) {
        String urlStr = String.valueOf(dataBase.convertRealName(baseName)) + dataBase.convertRealName(fileName);
        try {
            URL url = new URL(urlStr);
            HttpsURLConnection httpsURL = (HttpsURLConnection)url.openConnection();
            httpsURL.connect();
            InputStream is = httpsURL.getInputStream();
            BufferedInputStream bis = new BufferedInputStream(is);
            File newFile = new File(newFileName);
            FileOutputStream fos = new FileOutputStream(newFile);
            byte[] buffer = new byte[1024];
            int size = 0;
            while ((size = bis.read(buffer)) != -1) {
                fos.write(buffer, 0, size);
                fos.flush();
            }
        }
        catch (Exception e) {
            System.out.print("read or create file fail!");
        }
    }

    public static void coverFile(String oldFileName, String newFileName) {
        File oldFile = new File(oldFileName);
        File newFile = new File(newFileName);
        if (oldFile.exists()) {
            oldFile.delete();
        }
        try {
            int size;
            FileInputStream in = new FileInputStream(oldFile);
            FileOutputStream out = new FileOutputStream(newFile);
            byte[] buffer = new byte[5120];
            while ((size = in.read(buffer)) != -1) {
                out.write(buffer, 0, size);
                out.flush();
            }
            in.close();
            out.close();
        }
        catch (Exception e) {
            System.out.print(e.getMessage());
            System.out.print("cover file fail!");
        }
    }

    public static String getAppName() {
        return dataBase.convertRealName("appName");
    }
}

