/*
 * Decompiled with CFR 0.152.
 */
package eKeyboard;

import dataTools.DataScanner;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;

class Key {
    private int x;
    private int y;
    private int Width;
    private int Height;
    private int fingure;
    private String Master;
    private String Slave;
    private boolean isNext;
    private static final Color rColor = new Color(0, 136, 0);
    public static final int LCLEAR = 0;
    public static final int LTHUMB = 1;
    public static final int LINDEX = 2;
    public static final int LMIDDLE = 3;
    public static final int LRING = 4;
    public static final int LPINKIE = 5;
    public static final int RCLEAR = 6;
    public static final int RTHUMB = 7;
    public static final int RINDEX = 8;
    public static final int RMIDDLE = 9;
    public static final int RRING = 10;
    public static final int RPINKIE = 11;
    public static Image[] LfingureImg;
    public static Image[] RfingureImg;
    private static final Font KeyFont;
    protected Color bkColor;

    static {
        KeyFont = new Font("Keyboard", 0, 18);
    }

    public Key(int x, int y, int Width, int Height, String Master2, String Slave, int fingure) {
        this.x = x + 15;
        this.y = y + 10;
        this.Width = Width;
        this.Height = Height;
        this.Master = Master2;
        this.Slave = Slave;
        this.fingure = fingure;
        this.isNext = false;
        this.bkColor = new Color(253, 255, 230);
    }

    public void paintKey(Graphics g) {
        g.setFont(KeyFont);
        Graphics Range = g.create(this.x, this.y, this.Width, this.Height);
        Range.setColor(rColor);
        Range.drawRoundRect(2, 2, this.Width - 4, this.Height - 4, 2, 2);
        Range.drawRoundRect(3, 3, this.Width - 6, this.Height - 6, 2, 2);
        Range.drawRoundRect(4, 4, this.Width - 8, this.Height - 8, 2, 2);
        if (this.isNext) {
            Range.setColor(Color.black);
            Range.drawRoundRect(5, 5, this.Width - 10, this.Height - 10, 2, 2);
            Range.drawRoundRect(6, 6, this.Width - 12, this.Height - 12, 2, 2);
        } else {
            Range.setColor(this.bkColor);
            Range.fillRect(5, 5, this.Width - 9, this.Height - 9);
        }
        Range.setColor(Color.black);
        if (this.Slave.equals("invalid")) {
            Range.drawString(this.Master, (this.Width - Range.getFont().getSize() * this.Master.length() / 2) / 2, (Range.getFont().getSize() + this.Height) / 2);
        } else {
            Range.drawString(this.Master, (this.Width - Range.getFont().getSize() / 2) / 2, this.Height * 8 / 10);
            Range.drawString(this.Slave, (this.Width - Range.getFont().getSize() / 2) / 2, this.Height * 4 / 10);
        }
    }

    public void paintFingure(Graphics g, boolean fingureShift) {
        Graphics2D desk = (Graphics2D)g.create(5, 315, 675, 100);
        if (this.fingure == 1 || this.fingure == 7) {
            desk.drawImage(LfingureImg[1], 40, 0, null);
            desk.drawImage(RfingureImg[1], 300, 0, null);
            return;
        }
        int i = 2;
        while (i < 6) {
            if (this.fingure == i) {
                desk.drawImage(LfingureImg[i], 40, 0, null);
                if (fingureShift) {
                    desk.drawImage(RfingureImg[5], 300, 0, null);
                } else {
                    desk.drawImage(RfingureImg[0], 300, 0, null);
                }
                return;
            }
            ++i;
        }
        i = 8;
        while (i < 12) {
            if (this.fingure == i) {
                desk.drawImage(RfingureImg[i - 6], 300, 0, null);
                if (fingureShift) {
                    desk.drawImage(LfingureImg[5], 40, 0, null);
                } else {
                    desk.drawImage(LfingureImg[0], 40, 0, null);
                }
                return;
            }
            ++i;
        }
        desk.drawImage(LfingureImg[0], 40, 0, null);
        desk.drawImage(RfingureImg[0], 300, 0, null);
    }

    public void setNext() {
        this.isNext = true;
    }

    public void delNext() {
        this.isNext = false;
    }

    public String getMaster() {
        return this.Master;
    }

    public String getSlave() {
        return this.Slave;
    }

    public int getFingure() {
        return this.fingure;
    }

    public static void readImage(String imageBase) {
        LfingureImg = new Image[6];
        RfingureImg = new Image[6];
        String[] imageName = new String[]{"nleft.gif", "nleft1.gif", "nleft2.gif", "nleft3.gif", "nleft4.gif", "nleft5.gif", "nright.gif", "nright1.gif", "nright2.gif", "nright3.gif", "nright4.gif", "nright5.gif"};
        int i = 0;
        while (i < 6) {
            Key.LfingureImg[i] = DataScanner.readImage(imageBase, imageName[i]);
            Key.RfingureImg[i] = DataScanner.readImage(imageBase, imageName[i + 6]);
            ++i;
        }
    }
}

