/*
 * Decompiled with CFR 0.152.
 */
package eKeyboard;

import dataTools.Base;
import dataTools.DataScanner;
import dataTools.DataTrans;
import eDialog.ResultDialog;
import eDialog.SelectDialog;
import eKeyboard.Key;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JPanel;
import javax.swing.Timer;

public abstract class Keyboard
extends JPanel
implements KeyListener,
ActionListener {
    protected Color sColor = new Color(0, 136, 0);
    protected Color rColor = new Color(70, 105, 0);
    protected Color cColor = new Color(110, 165, 0);
    protected Color bkColor = new Color(253, 255, 230);
    protected Font kFont = new Font("Keyboard", 0, 15);
    protected Font tFont = new Font("Timer", 0, 24);
    protected String fileBase;
    protected String ImageBase;
    protected int limit;
    private int MaxNumber;
    protected Graphics2D desk;
    protected Image[] lfingure;
    protected Image[] rfingure;
    protected int nowFingure;
    private boolean keyShift;
    protected Timer timer;
    protected int timeLength;
    protected int remainTime;
    protected Key[] button;
    protected int nowKey;
    protected static final int NONE = -1;
    protected static int MAXROW = 4;
    protected String[] lines;
    protected int row;
    protected int column;
    protected int rowLen;
    protected int number;
    protected int tempP;
    protected boolean isTransfer;
    private Status status;

    protected Keyboard(int MaxNumber, String fileBase, String imageBase, boolean isTransfer) {
        this.MaxNumber = MaxNumber;
        this.fileBase = fileBase;
        this.isTransfer = isTransfer;
        Key.readImage(imageBase);
        this.createKeyboard();
        this.extendFileBase();
        this.setLimit();
        this.timeLength = 72;
        this.timer = new Timer(1000, this);
        this.nowKey = 0;
        this.nowFingure = 0;
    }

    public void selectDialog() {
        SelectDialog dialog = new SelectDialog(this, this.MaxNumber, this.limit);
    }

    protected void createKeyboard() {
    }

    protected void extendFileBase() {
        this.fileBase = String.valueOf(this.fileBase);
    }

    protected void setLimit() {
        this.limit = 0;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.bkColor);
        g.fillRect(0, 0, 780, 420);
        g.setColor(this.rColor);
        int i = 0;
        while (i < 5) {
            g.drawRect(i, i, 780 - 2 * i, 420 - 2 * i);
            ++i;
        }
        i = 1;
        while (i < 5) {
            g.drawRect(10 + i, 55 + i, 759 - 2 * i, 329 - 2 * i);
            ++i;
        }
        i = 0;
        while (i < this.button.length) {
            this.button[i].paintKey(g);
            ++i;
        }
        this.button[this.nowKey].paintFingure(g, this.keyShift);
        this.drawNumber(g);
        this.drawText(g);
        this.drawCaret(g);
        this.drawClock(g, true);
    }

    private void drawText(Graphics g) {
        Graphics display = g.create(5, 5, 770, 50);
        display.setColor(this.bkColor);
        display.fillRect(150, 0, 480, 50);
        display.setColor(this.sColor);
        display.setFont(this.kFont);
        int p = 390 - this.lines[this.row].length() * 6;
        int i = 0;
        while (i < this.lines[this.row].length()) {
            display.drawString(this.lines[this.row].substring(i, i + 1), p, 34);
            p += 12;
            ++i;
        }
    }

    private void drawCaret(Graphics g) {
        Graphics display = g.create(5, 5, 770, 50);
        display.setColor(this.bkColor);
        display.fillRect(this.tempP, 39, 8, 3);
        display.setColor(this.rColor);
        int p = 390 - this.lines[this.row].length() * 6;
        display.drawLine(p += this.column * 12, 39, p + 7, 39);
        display.drawLine(p, 40, p + 7, 40);
        display.drawLine(p, 41, p + 7, 41);
        display.setColor(this.sColor);
        this.tempP = p;
    }

    protected void drawClock(Graphics g, boolean repaint) {
        Graphics display = g.create(5, 5, 770, 50);
        display.setFont(this.kFont);
        Graphics clock = g.create(675, 315, 100, 100);
        if (repaint) {
            clock.setColor(this.cColor);
            clock.fillOval(1, 1, 98, 98);
            clock.setColor(Color.white);
            clock.fillOval(7, 7, 86, 86);
            clock.setColor(this.rColor);
            clock.fillArc(6, 6, 88, 88, 90, (this.remainTime - this.timeLength) * 5);
        } else if (this.remainTime > 0) {
            clock.setColor(this.rColor);
            clock.fillArc(6, 6, 88, 88, 90 + (this.remainTime - this.timeLength) * 5, 5);
        }
        display.setColor(this.bkColor);
        display.fillRect(722, 0, 40, 50);
        display.setColor(this.sColor);
        display.setFont(this.tFont);
        if (this.remainTime > 99) {
            display.drawString(Integer.toString(this.remainTime), 722, 30);
        } else if (this.remainTime > 9) {
            display.drawString(Integer.toString(this.remainTime), 734, 30);
        } else {
            display.drawString(Integer.toString(this.remainTime), 746, 30);
        }
    }

    public void drawNumber(Graphics g) {
        Graphics display = g.create(5, 5, 770, 50);
        display.setColor(this.bkColor);
        display.fillRect(0, 0, 700, 50);
        display.setColor(this.sColor);
        display.setFont(new Font("Number", 0, 24));
        display.drawString(Integer.toString(this.number), 12, 30);
        display.setFont(this.kFont);
        display.drawString("940928", 12, 50);
    }

    public void prepare(int lessonNum) {
        this.status = Status.Stop;
        this.remainTime = this.timeLength;
        this.number = lessonNum;
        this.readLesson(lessonNum);
        this.keyShift = false;
        this.row = 0;
        this.column = 0;
        this.setKey(this.lines[this.row].substring(this.column, this.column + 1));
        this.rowLen = this.lines[this.row].length();
        this.tempP = 390 - this.rowLen * 6;
    }

    protected void readLesson(int lessonNum) {
        int head;
        lessonNum = lessonNum < this.limit ? lessonNum : this.limit;
        lessonNum = lessonNum > 1 ? lessonNum : 1;
        String fileName = "";
        fileName = lessonNum > 99 ? String.valueOf(fileName) + lessonNum : (lessonNum > 9 ? String.valueOf(fileName) + "0" + lessonNum : String.valueOf(fileName) + "00" + lessonNum);
        String text = DataScanner.readText(this.fileBase, fileName);
        this.lines = new String[MAXROW];
        int tail = head = 0;
        int i = 0;
        while (i < MAXROW) {
            tail = text.indexOf(DataScanner.Enter, tail);
            this.lines[i] = text.substring(head, tail);
            head = ++tail;
            ++i;
        }
    }

    protected void start() {
        this.timer.start();
        this.status = Status.Start;
    }

    protected void sendData() {
        try {
            DataTrans dataTrans = new DataTrans("tSumURL");
            dataTrans.connect();
            dataTrans.openOut();
            dataTrans.write("&examCode=T13");
            dataTrans.write("&status=W");
            dataTrans.write("&user=" + Base.user);
            dataTrans.write("&time=" + Integer.toString(this.timeLength - this.remainTime));
            dataTrans.write("&prob=" + Integer.toString(this.number));
            dataTrans.write("&type=4");
            dataTrans.closeOut();
            dataTrans.POSTfinshOut();
        }
        catch (Exception e) {
            System.out.print("connect error!");
        }
    }

    protected void finish() {
        this.timer.stop();
        this.status = Status.Finsh;
        this.sendData();
        int KPM = 0;
        if (this.remainTime > 0) {
            KPM = 7200 / (this.timeLength - this.remainTime);
        }
        if (this.remainTime > 0) {
            this.MaxNumber = Math.max(this.number + 1, this.MaxNumber);
            ResultDialog resultDialog = new ResultDialog(this, this.number, KPM, true);
        } else {
            ResultDialog resultDialog = new ResultDialog(this, this.number, KPM, false);
        }
    }

    public void repeatLesson() {
        this.prepare(this.number);
    }

    public void nextLesson() {
        this.prepare(++this.number);
    }

    public void previousLesson() {
        this.prepare(--this.number);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        String c = Character.toString(e.getKeyChar());
        this.testKey(c);
    }

    protected String dispatch(String c) {
        return c;
    }

    protected void testKey(String c) {
        if (this.status == Status.Stop) {
            this.start();
        }
        if (this.status != Status.Start) {
            return;
        }
        if (!(c = this.dispatch(c)).equals(this.lines[this.row].substring(this.column, this.column + 1))) {
            return;
        }
        if (this.column + 1 != this.rowLen) {
            ++this.column;
            this.setKey(this.lines[this.row].substring(this.column, this.column + 1));
            this.drawCaret(this.getGraphics());
            return;
        }
        if (this.row + 1 != MAXROW) {
            ++this.row;
            this.column = 0;
            this.rowLen = this.lines[this.row].length();
            this.setKey(this.lines[this.row].substring(this.column, this.column + 1));
            this.drawText(this.getGraphics());
            this.drawCaret(this.getGraphics());
            return;
        }
        this.finish();
    }

    protected void setKey(String c) {
        Graphics g = this.getGraphics();
        int nextKey = this.findKey(c);
        if (nextKey == this.nowKey) {
            return;
        }
        this.button[this.nowKey].delNext();
        this.button[this.nowKey].paintKey(g);
        this.button[nextKey].setNext();
        this.button[nextKey].paintKey(g);
        this.nowKey = nextKey;
        if (this.keyShift) {
            if (this.button[nextKey].getFingure() > 5) {
                this.button[41].setNext();
                this.button[41].paintKey(g);
            } else {
                this.button[52].setNext();
                this.button[52].paintKey(g);
            }
        } else {
            this.button[41].delNext();
            this.button[41].paintKey(g);
            this.button[52].delNext();
            this.button[52].paintKey(g);
        }
        int nextFingure = this.button[nextKey].getFingure();
        this.button[nextKey].paintFingure(g, this.keyShift);
        this.nowFingure = nextFingure;
    }

    protected int findKey(String c) {
        int i = 0;
        while (i < 58) {
            if (c.equals(this.button[i].getMaster().toLowerCase())) {
                this.keyShift = false;
                return i;
            }
            if (c.equals(this.button[i].getMaster())) {
                System.out.print(i);
                this.keyShift = true;
                return i;
            }
            if (c.equals(this.button[i].getSlave())) {
                this.keyShift = true;
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.remainTime > 0) {
            --this.remainTime;
            this.drawClock(this.getGraphics(), false);
        } else {
            this.timer.stop();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private static enum Status {
        Stop,
        Start,
        Finsh;

    }
}

