/*
 * Decompiled with CFR 0.152.
 */
package eKeyboard;

import eKeyboard.Key;
import eKeyboard.Keyboard;

public class QwertyKeyboard
extends Keyboard {
    private static final String qwertyStr = "`1234567890-=qwertyuiop[]asdfghjkl;'zxcvbnm,./~!@#$%^&*()_+QWERTYUIOP{}ASDFGHJKL:\"ZXCVBNM<>?";
    private static final String dvorakStr = "`1234567890[]',.pyfgcrl/=aoeuidhtns-;qjkxbmwvz~!@#$%^&*(){}\"<>PYFGCRL?+AOEUIDHTNS_:QJKXBMWVZ";
    private static final int strLen = "`1234567890-=qwertyuiop[]asdfghjkl;'zxcvbnm,./~!@#$%^&*()_+QWERTYUIOP{}ASDFGHJKL:\"ZXCVBNM<>?".length();

    protected QwertyKeyboard(int MaxNumber, String fileBase, String imageBase, boolean isTransfer) {
        super(MaxNumber, fileBase, imageBase, isTransfer);
    }

    @Override
    protected void extendFileBase() {
        this.fileBase = String.valueOf(this.fileBase) + "qwerty/";
    }

    @Override
    protected void setLimit() {
        this.limit = 150;
    }

    @Override
    protected void createKeyboard() {
        this.button = new Key[58];
        this.button[0] = new Key(0, 50, 50, 50, "`", "~", 5);
        this.button[1] = new Key(50, 50, 50, 50, "1", "!", 5);
        this.button[2] = new Key(100, 50, 50, 50, "2", "@", 4);
        this.button[3] = new Key(150, 50, 50, 50, "3", "#", 3);
        this.button[4] = new Key(200, 50, 50, 50, "4", "$", 2);
        this.button[5] = new Key(250, 50, 50, 50, "5", "%", 2);
        this.button[6] = new Key(300, 50, 50, 50, "6", "^", 8);
        this.button[7] = new Key(350, 50, 50, 50, "7", "&", 8);
        this.button[8] = new Key(400, 50, 50, 50, "8", "*", 9);
        this.button[9] = new Key(450, 50, 50, 50, "9", "(", 10);
        this.button[10] = new Key(500, 50, 50, 50, "0", ")", 11);
        this.button[11] = new Key(550, 50, 50, 50, "-", "_", 11);
        this.button[12] = new Key(600, 50, 50, 50, "=", "+", 11);
        this.button[13] = new Key(650, 50, 100, 50, "Backspace", "invalid", 11);
        this.button[14] = new Key(0, 100, 75, 50, "Tab", "invalid", 5);
        this.button[15] = new Key(75, 100, 50, 50, "Q", "invalid", 5);
        this.button[16] = new Key(125, 100, 50, 50, "W", "invalid", 4);
        this.button[17] = new Key(175, 100, 50, 50, "E", "invalid", 3);
        this.button[18] = new Key(225, 100, 50, 50, "R", "invalid", 2);
        this.button[19] = new Key(275, 100, 50, 50, "T", "invalid", 2);
        this.button[20] = new Key(325, 100, 50, 50, "Y", "invalid", 8);
        this.button[21] = new Key(375, 100, 50, 50, "U", "invalid", 8);
        this.button[22] = new Key(425, 100, 50, 50, "I", "invalid", 9);
        this.button[23] = new Key(475, 100, 50, 50, "O", "invalid", 10);
        this.button[24] = new Key(525, 100, 50, 50, "P", "invalid", 11);
        this.button[25] = new Key(575, 100, 50, 50, "[", "{", 11);
        this.button[26] = new Key(625, 100, 50, 50, "]", "}", 11);
        this.button[27] = new Key(675, 100, 75, 50, "\\", "|", 11);
        this.button[28] = new Key(0, 150, 90, 50, "CapsLock", "invalid", 5);
        this.button[29] = new Key(90, 150, 50, 50, "A", "invalid", 5);
        this.button[30] = new Key(140, 150, 50, 50, "S", "invalid", 4);
        this.button[31] = new Key(190, 150, 50, 50, "D", "invalid", 3);
        this.button[32] = new Key(240, 150, 50, 50, "F", "invalid", 2);
        this.button[33] = new Key(290, 150, 50, 50, "G", "invalid", 2);
        this.button[34] = new Key(340, 150, 50, 50, "H", "invalid", 8);
        this.button[35] = new Key(390, 150, 50, 50, "J", "invalid", 8);
        this.button[36] = new Key(440, 150, 50, 50, "K", "invalid", 9);
        this.button[37] = new Key(490, 150, 50, 50, "L", "invalid", 10);
        this.button[38] = new Key(540, 150, 50, 50, ";", ":", 11);
        this.button[39] = new Key(590, 150, 50, 50, "'", "\"", 11);
        this.button[40] = new Key(640, 150, 110, 50, "Enter", "invalid", 11);
        this.button[41] = new Key(0, 200, 100, 50, "Shift", "invalid", 5);
        this.button[42] = new Key(100, 200, 50, 50, "Z", "invalid", 5);
        this.button[43] = new Key(150, 200, 50, 50, "X", "invalid", 4);
        this.button[44] = new Key(200, 200, 50, 50, "C", "invalid", 3);
        this.button[45] = new Key(250, 200, 50, 50, "V", "invalid", 2);
        this.button[46] = new Key(300, 200, 50, 50, "B", "invalid", 2);
        this.button[47] = new Key(350, 200, 50, 50, "N", "invalid", 8);
        this.button[48] = new Key(400, 200, 50, 50, "M", "invalid", 8);
        this.button[49] = new Key(450, 200, 50, 50, ",", "<", 9);
        this.button[50] = new Key(500, 200, 50, 50, ".", ">", 10);
        this.button[51] = new Key(550, 200, 50, 50, "/", "?", 11);
        this.button[52] = new Key(600, 200, 150, 50, "Shift", "invalid", 11);
        this.button[53] = new Key(0, 250, 75, 50, "Ctrl", "invalid", 5);
        this.button[54] = new Key(140, 250, 60, 50, "Alt", "invalid", 5);
        this.button[55] = new Key(200, 250, 290, 50, " ", "invalid", 1);
        this.button[56] = new Key(490, 250, 60, 50, "Alt", "invalid", 9);
        this.button[57] = new Key(675, 250, 75, 50, "Ctrl", "invalid", 11);
    }

    @Override
    protected String dispatch(String c) {
        if (this.isTransfer) {
            return QwertyKeyboard.DvorakToQwerty(c);
        }
        return c;
    }

    private static String DvorakToQwerty(String c) {
        String text = "";
        int i = 0;
        while (i < c.length()) {
            boolean found = false;
            int j = 0;
            while (j < strLen) {
                if (c.charAt(i) == dvorakStr.charAt(j)) {
                    text = String.valueOf(text) + qwertyStr.charAt(j);
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                text = String.valueOf(text) + c.charAt(i);
            }
            ++i;
        }
        return text;
    }
}

