/*
 * Decompiled with CFR 0.152.
 */
package eTypeStory;

import eTypeStory.DrawBoard;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

class Display
extends JPanel {
    private GridLayout gridLayout = new GridLayout();
    private Border centerBorder = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), BorderFactory.createEmptyBorder(4, 4, 4, 4));
    private Border topBarBorder = BorderFactory.createRaisedBevelBorder();
    private Border bottomBarBorder = this.centerBorder;
    private Color topBarBg = SystemColor.activeCaption;
    private Color topBarFg = Color.white;
    private Font barFt = new Font("Dialog", 1, 14);
    private JPanel topBar = new JPanel();
    private JPanel bottomBar = new JPanel();
    private JLabel[] topJLabel = new JLabel[2];
    private JLabel[] bottomJLabel = new JLabel[5];
    private DrawBoard drawBoard;

    public Display() {
        this.decorate();
        this.drawBoard = new DrawBoard();
        this.add(this.drawBoard);
    }

    public void printResult(int typeCount, int errCount, int accuracy, int time, int speed) {
        if (typeCount < 700) {
            this.bottomJLabel[0].setForeground(Color.red);
        }
        if (accuracy < 90) {
            this.bottomJLabel[2].setForeground(Color.red);
        }
        if (speed == -1) {
            this.bottomJLabel[4].setForeground(Color.red);
        }
        this.bottomJLabel[0].setText("  Type: " + typeCount);
        this.bottomJLabel[1].setText("Error: " + errCount);
        this.bottomJLabel[2].setText("Accuracy: " + accuracy + " %");
        this.bottomJLabel[3].setText("Time: " + time + " sec");
        this.bottomJLabel[4].setText("Speed: " + speed + " KPM");
        this.bottomBar.repaint();
    }

    private void decorate() {
        this.setLayout(null);
        this.setBounds(0, 0, 640, 480);
        this.setBorder(this.centerBorder);
        this.setBackground(Color.white);
        this.topBar.setLayout(this.gridLayout);
        this.topBar.setBounds(2, 2, 636, 24);
        this.topBar.setBorder(this.topBarBorder);
        this.topBar.setBackground(this.topBarBg);
        this.add((Component)this.topBar, null);
        this.bottomBar.setLayout(this.gridLayout);
        this.bottomBar.setBounds(2, 454, 636, 24);
        this.bottomBar.setBorder(this.bottomBarBorder);
        this.add((Component)this.bottomBar, null);
        int i = 0;
        while (i < this.topJLabel.length) {
            this.topJLabel[i] = new JLabel();
            this.topJLabel[i].setFont(this.barFt);
            this.topJLabel[i].setForeground(this.topBarFg);
            this.topBar.add((Component)this.topJLabel[i], null);
            ++i;
        }
        this.topJLabel[0].setText("  Typing Test v1.0e");
        this.topJLabel[1].setHorizontalAlignment(4);
        this.topJLabel[1].setText("Copyright (C) snoweye of MCL  ");
        i = 0;
        while (i < this.bottomJLabel.length) {
            this.bottomJLabel[i] = new JLabel();
            this.bottomJLabel[i].setRequestFocusEnabled(false);
            this.bottomBar.add((Component)this.bottomJLabel[i], null);
            ++i;
        }
        this.bottomJLabel[0].setText("  [Esc]  to skip");
        this.bottomJLabel[1].setText(" [F12]  to stop");
    }

    public DrawBoard getDrawBoard() {
        return this.drawBoard;
    }
}

