/*
 * Decompiled with CFR 0.152.
 */
package eTypeStory;

import dataTools.Base;
import dataTools.DataScanner;
import dataTools.DataTrans;
import eTypeStory.Display;
import eTypeStory.DrawBoard;
import java.awt.event.KeyEvent;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import line.EchoLine;
import line.ErrorLine;
import line.Line;
import line.StoryLine;

class StoryBook {
    private String etype;
    private String fileBase;
    private String fileName;
    private int totalLine = 5;
    private int endLine;
    private boolean hasMore;
    private StringTokenizer strTk;
    private Display display;
    private DrawBoard drawBoard;
    private Line line;
    private ErrorLine errorLine;
    private StoryLine storyLine;
    private EchoLine echoLine;
    private long startTime;
    private long timeLength;
    private int posX;
    private int posY;
    private int nowStrLen;
    private int typeCount;
    private int errorCount;
    private Status status;

    public StoryBook(String etype, String fileBase, String fileName, Display display) {
        this.etype = etype;
        this.fileBase = fileBase;
        this.fileName = fileName;
        this.display = display;
        this.drawBoard = display.getDrawBoard();
        this.status = Status.Stop;
        this.takeBook();
        this.newPage();
    }

    private void takeBook() {
        String text = DataScanner.readText(this.fileBase, this.fileName);
        text = text.replaceAll(DataScanner.Enter, " <br> ");
        this.strTk = new StringTokenizer(text);
    }

    private void newPage() {
        int i = 0;
        while (i < this.totalLine) {
            this.chooseLine(i);
            this.errorLine.clearError();
            this.echoLine.clearMsg();
            String lineStr = "";
            while (this.strTk.hasMoreTokens()) {
                String word = this.strTk.nextToken();
                if (!word.equals("<br>")) {
                    lineStr = String.valueOf(lineStr) + word + " ";
                    continue;
                }
                this.endLine = i;
                break;
            }
            this.storyLine.readLine(lineStr);
            this.hasMore = this.strTk.hasMoreTokens();
            ++i;
        }
        this.posX = 0;
        this.posY = 0;
        this.chooseLine(0);
        this.nowStrLen = this.storyLine.getStrLen();
        this.echoLine.showCaret(true);
    }

    private void chooseLine(int lineNum) {
        this.line = this.drawBoard.getLine(lineNum);
        this.errorLine = this.line.getErrorLine();
        this.storyLine = this.line.getStoryLine();
        this.echoLine = this.line.getEchoLine();
    }

    public void keyPressed(KeyEvent e) {
        if (this.status != Status.Start) {
            return;
        }
        int key = e.getKeyCode();
        switch (key) {
            case 27: {
                this.status = Status.Esc;
                this.echoLine.showCaret(false);
                this.calGrade();
                break;
            }
            case 123: {
                this.status = Status.F12;
                this.echoLine.showCaret(false);
                this.calGrade();
                break;
            }
            case 8: 
            case 127: {
                if (this.posX <= 0) break;
                --this.posX;
                --this.typeCount;
                this.echoLine.delete();
                if (!this.errorLine.isError(this.posX)) break;
                this.errorLine.removeError();
                --this.errorCount;
                break;
            }
            case 10: {
                if (this.posX != this.nowStrLen - 1) break;
                ++this.typeCount;
                this.echoLine.write(' ');
                this.nextLine();
            }
        }
    }

    public void keyType(KeyEvent e) {
        char key = e.getKeyChar();
        if (this.status == Status.Stop && key >= ' ' && key <= '~') {
            this.status = Status.Start;
            this.startTime = System.currentTimeMillis();
        }
        if (this.status != Status.Start) {
            return;
        }
        if (key >= ' ' && key <= '~') {
            if (this.posX < this.nowStrLen) {
                if (!this.storyLine.isRight(key, this.posX)) {
                    ++this.errorCount;
                    this.errorLine.addError(this.posX);
                }
                this.echoLine.write(key);
                ++this.typeCount;
                ++this.posX;
            }
            if (this.posX == this.nowStrLen) {
                this.nextLine();
            }
        }
    }

    private void nextLine() {
        this.echoLine.showCaret(false);
        if (this.posY != this.endLine) {
            this.posX = 0;
            ++this.posY;
            this.chooseLine(this.posY);
            this.nowStrLen = this.storyLine.getStrLen();
            this.echoLine.showCaret(true);
        } else if (this.hasMore) {
            this.newPage();
        } else {
            this.status = Status.Finish;
            this.echoLine.showCaret(false);
            this.calGrade();
        }
    }

    public void calGrade() {
        block6: {
            int accuracy = 0;
            int speed = -1;
            this.timeLength = System.currentTimeMillis() - this.startTime;
            int time = (int)Math.ceil((double)this.timeLength / 1000.0);
            if (this.typeCount != 0) {
                accuracy = (int)Math.ceil(100.0 * (double)(this.typeCount - this.errorCount) / (double)this.typeCount);
            }
            if (accuracy > 90 & this.typeCount > 700) {
                speed = (int)Math.ceil((double)(this.typeCount - this.errorCount) / ((double)this.timeLength / 60000.0));
            }
            if (this.status == Status.Esc) {
                speed = -1;
            }
            this.display.printResult(this.typeCount, this.errorCount, accuracy, time, speed);
            if (speed > 399 && this.etype == "E") {
                String labelMsg = "<html><h2>\u60a8\u7684\u6210\u7e3e\u975e\u51e1\u4eba\u6240\u80fd\uff0c\u8acb\u5c07\u87a2\u5e55\u62cd\u7167\u6216\u8005\u64f7\u5716\u5b58\u8b49\uff0c</h2><h2>\u62ff\u53bb\u627e\u6388\u8ab2\u6559\u5e2b\u6216 bcc16 \u7db2\u7ba1\uff0c\u8acb\u4ed6/\u5979\u9a57\u8b49\u4e4b\u5f8c\u5e6b\u60a8\u767b\u8a18\u6210\u7e3e\u3002</h2><h2>\u6b64\u4efd\u6210\u7e3e\u66ab\u6642\u4e26\u672a\u767b\u8a18\u3002</h2><h2>Type: " + this.typeCount + ", " + "Error: " + this.errorCount + ", " + "accuracy: " + accuracy + "%, " + "time: " + time + " sec, " + "speed: " + speed + " KPM</h2>" + "<h2> <span align=\"right\">  \u4f7f\u7528\u8005\uff1a" + Base.name + " </span> </h2>" + "</html>";
                JOptionPane.showMessageDialog(null, new JLabel(labelMsg));
                speed = -1;
            }
            try {
                DataTrans dataTrans = new DataTrans("tSumURL");
                dataTrans.connect();
                dataTrans.openOut();
                dataTrans.write("&examCode=T11");
                dataTrans.write("&status=W");
                dataTrans.write("&user=" + Base.user);
                dataTrans.write("&type=" + this.etype);
                dataTrans.write("&score=" + speed);
                dataTrans.write("&time=" + time);
                dataTrans.closeOut();
                dataTrans.POSTfinshOut();
            }
            catch (Exception e) {
                if (this.etype != "E") break block6;
                String labelMsg = "<html><h2>\u9023\u7dda\u932f\u8aa4\uff01\uff01\u8acb\u5c07\u87a2\u5e55\u62cd\u7167\u6216\u8005\u64f7\u5716</h2><h2>\u62ff\u53bb\u627e\u6388\u8ab2\u6559\u5e2b\u6216 bcc16 \u7db2\u7ba1\uff0c\u8acb\u4ed6/\u5979\u5e6b\u60a8\u767b\u8a18\u6210\u7e3e\u3002</h2><h2>\u6b64\u4efd\u6210\u7e3e\u66ab\u6642\u4e26\u672a\u767b\u8a18\u3002</h2><h2>Type: " + this.typeCount + ", " + "Error: " + this.errorCount + ", " + "accuracy: " + accuracy + "%, " + "time: " + time + " sec, " + "speed: " + speed + " KPM</h2>" + "<h2> <span align=\"right\">  \u4f7f\u7528\u8005\uff1a" + Base.name + " </span> </h2>" + "</html>";
                JOptionPane.showMessageDialog(null, new JLabel(labelMsg));
            }
        }
    }

    private static enum Status {
        Stop,
        Start,
        Esc,
        F12,
        Finish;

    }
}

