/*
 * Decompiled with CFR 0.152.
 */
package frog;

import dataTools.Base;
import dataTools.DataScanner;
import dataTools.DataTrans;
import frMaster.Master;
import frog.Frog;
import frog.PDialog;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;

class ControlPanel
extends JPanel
implements ActionListener {
    private String etype;
    private Master master;
    JButton Problem;
    JButton Fast;
    JButton Slow;
    JButton Stop;
    JButton Resume;
    JButton Reset;
    JTextField input;
    String code;
    int codeCounter;
    Frog problemFrog;
    Frog userFrog;
    Timer frogTimer;
    Timer userTimer;
    int duration;
    static int errorCounter = 0;
    int chooedPro;
    int passedPro;

    public ControlPanel(String etype, Master master) {
        this.etype = etype;
        this.master = master;
        this.draw();
        this.init();
    }

    public void draw() {
        this.setBackground(new Color(253, 255, 230));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 7));
        this.Problem = new JButton("\u91cd\u65b0\u51fa\u984c");
        this.Fast = new JButton("\u5feb\u901f\u57f7\u884c");
        this.Slow = new JButton("\u4f4e\u901f\u57f7\u884c");
        this.Stop = new JButton("\u66ab\u505c\u57f7\u884c");
        this.Resume = new JButton("\u7e7c\u7e8c\u57f7\u884c");
        this.Reset = new JButton("\u6e05\u9664\u68cb\u76e4");
        this.Problem.addActionListener(this);
        this.Fast.addActionListener(this);
        this.Slow.addActionListener(this);
        this.Stop.addActionListener(this);
        this.Resume.addActionListener(this);
        this.Reset.addActionListener(this);
        buttonPanel.add(this.Problem);
        buttonPanel.add(this.Fast);
        buttonPanel.add(this.Slow);
        buttonPanel.add(this.Stop);
        buttonPanel.add(this.Resume);
        buttonPanel.add(this.Reset);
        this.setLayout(null);
        buttonPanel.setBounds(0, 0, 630, 40);
        this.add(buttonPanel);
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new GridLayout(1, 1));
        this.input = new JTextField(20);
        inputPanel.add(this.input);
        inputPanel.setBounds(90, 45, 520, 30);
        this.add(inputPanel);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(1, 1));
        JLabel label = new JLabel("\u6307\u4ee4", 0);
        labelPanel.add(label);
        labelPanel.setOpaque(false);
        labelPanel.setBounds(0, 45, 90, 30);
        this.add(labelPanel);
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new GridLayout(1, 2));
        JLabel problemLabel = new JLabel("\u984c\u76ee", 0);
        JLabel frogLabel = new JLabel("\u9752\u86d9\u5716", 0);
        titlePanel.add(problemLabel);
        titlePanel.add(frogLabel);
        titlePanel.setOpaque(false);
        titlePanel.setBounds(0, 80, 630, 30);
        this.add(titlePanel);
        this.problemFrog = new Frog(30, 30, 8, 8, false);
        this.problemFrog.setBounds(23, 115, 274, 274);
        this.add(this.problemFrog);
        this.userFrog = new Frog(30, 30, 8, 8, true);
        this.userFrog.setBounds(338, 115, 274, 274);
        this.add(this.userFrog);
    }

    private void setBtnEnable(boolean problem, boolean fast, boolean slow, boolean stop, boolean resume, boolean reset) {
        if (this.etype == "E") {
            this.Problem.setEnabled(false);
        } else {
            this.Problem.setEnabled(problem);
        }
        this.Fast.setEnabled(fast);
        this.Slow.setEnabled(slow);
        this.Stop.setEnabled(stop);
        this.Resume.setEnabled(resume);
        this.Reset.setEnabled(reset);
    }

    public void init() {
        this.setBtnEnable(true, true, true, false, false, false);
        this.code = "";
        this.codeCounter = 0;
        this.frogTimer = new Timer(1, this);
        this.frogTimer.stop();
        this.userTimer = new Timer(1000, this);
        this.userTimer.stop();
        this.duration = 0;
        this.chooedPro = -1;
        try {
            DataTrans dataTrans = new DataTrans("tSumURL");
            dataTrans.connect();
            dataTrans.openOut();
            dataTrans.write("&examCode=TCD");
            dataTrans.write("&status=RD");
            dataTrans.write("&user=" + Base.user);
            dataTrans.closeOut();
            dataTrans.openIn();
            String data = dataTrans.getLine();
            this.passedPro = Integer.parseInt(data);
            this.passedPro /= 16;
            dataTrans.closeIn();
            if (data == "C") {
                throw new Exception();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "\u7121\u6cd5\u9023\u63a5\u4e0a\u8cc7\u6599\u5eab", "\u932f\u8aa4", -1);
        }
        if (this.etype == "E") {
            this.problemBtn();
        }
    }

    private String analyInst(String text) {
        String answer = "";
        text = text.replaceAll(" ", "");
        text = text.replaceAll("\t", "");
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c >= '0' && c <= '5') {
                answer = String.valueOf(answer) + c;
            } else if (c == '6') {
                if (++i >= text.length()) {
                    answer = String.valueOf(answer) + 'X';
                    return answer;
                }
                char step = text.charAt(i);
                if (step == '0') {
                    answer = String.valueOf(answer) + '6';
                } else {
                    int j = 0;
                    while (j < step - 48) {
                        answer = String.valueOf(answer) + '5';
                        ++j;
                    }
                }
            } else {
                answer = String.valueOf(answer) + 'N';
                return answer;
            }
            ++i;
        }
        return answer;
    }

    private boolean runAinst(Frog frog, int inst) {
        switch (inst) {
            case 48: {
                frog.instEND();
                break;
            }
            case 49: {
                frog.instUP();
                break;
            }
            case 50: {
                frog.instDOWN();
                break;
            }
            case 51: {
                frog.instRTURN();
                break;
            }
            case 52: {
                frog.instLTURN();
                break;
            }
            case 53: {
                return frog.instJUMP(1);
            }
            case 54: {
                return frog.instJUMP(0);
            }
            case 78: {
                JOptionPane.showMessageDialog(null, "\u672a\u5b9a\u7fa9\u7684\u7b26\u865f", "\u932f\u8aa4", -1);
                break;
            }
            case 88: {
                JOptionPane.showMessageDialog(null, "6\u5f8c\u9762\u6c92\u6709\u6578\u5b57", "\u932f\u8aa4", -1);
            }
        }
        return true;
    }

    private void getProblem() {
        try {
            if (this.etype == "T") {
                PDialog pDialog = new PDialog(this, this.passedPro);
            } else if (this.etype == "E") {
                this.chooedPro = (int)(Base.openTime % 8L + 8L);
            }
            String pro = DataScanner.readText("frogProblemBase/", "" + this.chooedPro);
            pro = this.analyInst(pro);
            int i = 0;
            while (i < pro.length()) {
                char inst = pro.charAt(i);
                if (!this.runAinst(this.problemFrog, inst)) {
                    this.chooedPro = -1;
                    JOptionPane.showMessageDialog(null, "\u984c\u76ee\u767c\u751f\u932f\u8aa4", "\u932f\u8aa4", -1);
                    break;
                }
                ++i;
            }
            this.input.setText("");
            this.duration = 0;
            this.userTimer.restart();
        }
        catch (Exception e) {
            this.chooedPro = -1;
            JOptionPane.showMessageDialog(null, "\u7121\u6cd5\u53d6\u5f97\u984c\u76ee", "\u932f\u8aa4", -1);
        }
    }

    private void problemBtn() {
        this.frogTimer.stop();
        this.userFrog.reset();
        this.problemFrog.reset();
        this.setBtnEnable(true, true, true, false, false, false);
        this.getProblem();
    }

    private boolean prepare() {
        this.userFrog.reset();
        this.codeCounter = 0;
        this.code = this.analyInst(this.input.getText());
        if (this.code == "Error") {
            this.setBtnEnable(false, false, false, false, false, true);
            return false;
        }
        return true;
    }

    private void fastBtn() {
        if (!this.prepare()) {
            return;
        }
        this.frogTimer.setDelay(1);
        this.frogTimer.restart();
        this.setBtnEnable(false, false, false, true, false, false);
    }

    private void sendBtn(int type) {
        this.frogTimer.stop();
        int tempPassPro = this.passedPro * 16;
        String msg = "";
        if (this.etype == "E") {
            msg = String.valueOf(msg) + "\u985e\u578b: \u8003\u8a66\n";
            tempPassPro = 0;
        } else if (this.etype == "T") {
            msg = String.valueOf(msg) + "\u985e\u578b: \u7df4\u7fd2\n";
            int temp = 1;
            int i = 0;
            while (i < this.chooedPro + 4) {
                temp *= 2;
                ++i;
            }
            tempPassPro |= temp;
            tempPassPro += this.chooedPro * 2;
        }
        if (type == 3) {
            if (this.etype == "E") {
                double examScore = 100.0;
                int i = 0;
                while (i < errorCounter) {
                    examScore *= 0.9;
                    ++i;
                }
                tempPassPro = (int)(examScore + 0.5);
            } else {
                this.passedPro = tempPassPro / 16;
                ++tempPassPro;
            }
        }
        try {
            DataTrans dataTrans = new DataTrans("tSumURL");
            dataTrans.connect();
            dataTrans.openOut();
            dataTrans.write("&examCode=TCD");
            dataTrans.write("&status=W");
            dataTrans.write("&user=" + Base.user);
            dataTrans.write("&etype=" + this.etype);
            dataTrans.write("&score=" + tempPassPro);
            dataTrans.write("&duration=" + this.duration);
            dataTrans.closeOut();
            dataTrans.openIn();
            String result = dataTrans.getLine();
            dataTrans.closeIn();
            if (result == "C") {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (type) {
            case 0: {
                JOptionPane.showMessageDialog(null, "\u5716\u5f62\u4e0d\u7b26", "\u5931\u6557", -1);
                ++errorCounter;
                break;
            }
            case 1: {
                JOptionPane.showMessageDialog(null, "\u4e0d\u53ef\u4ee5\u8b93\u9752\u86d9\u8d85\u51fa\u908a\u754c", "\u5931\u6557", -1);
                ++errorCounter;
                break;
            }
            case 2: {
                JOptionPane.showMessageDialog(null, "\u7a0b\u5f0f\u7d50\u5c3e\u6c92\u6709\u4ee5 0 \u7d50\u675f", "\u5931\u6557", -1);
                ++errorCounter;
                break;
            }
            case 3: {
                msg = this.etype == "T" ? String.valueOf(msg) + "\u6642\u9593: " : String.valueOf(msg) + "\u5206\u6578: ";
                msg = String.valueOf(msg) + Integer.toString(this.duration) + "\n";
                JOptionPane.showMessageDialog(null, msg, "\u901a\u904e", -1);
                this.input.setText("");
                this.duration = 0;
            }
        }
        this.userTimer.restart();
        this.setBtnEnable(false, false, false, false, false, true);
    }

    private void slowBtn() {
        if (!this.prepare()) {
            return;
        }
        this.frogTimer.setDelay(500);
        this.frogTimer.restart();
        this.setBtnEnable(false, false, false, true, false, false);
    }

    private void stopBtn() {
        this.frogTimer.stop();
        this.setBtnEnable(false, false, false, false, true, true);
    }

    private void resumeBtn() {
        this.frogTimer.start();
        this.setBtnEnable(false, false, false, true, false, false);
    }

    private void resetBtn() {
        this.frogTimer.stop();
        this.userFrog.reset();
        this.setBtnEnable(true, true, true, false, false, false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.Problem) {
            this.problemBtn();
        } else if (e.getSource() == this.Fast) {
            this.fastBtn();
        } else if (e.getSource() == this.Slow) {
            this.slowBtn();
        } else if (e.getSource() == this.Stop) {
            this.stopBtn();
        } else if (e.getSource() == this.Resume) {
            this.resumeBtn();
        } else if (e.getSource() == this.Reset) {
            this.resetBtn();
        } else if (e.getSource() == this.frogTimer) {
            if (this.codeCounter < this.code.length()) {
                char inst = this.code.charAt(this.codeCounter);
                if (!this.runAinst(this.userFrog, inst)) {
                    this.frogTimer.stop();
                    this.setBtnEnable(true, true, true, false, false, false);
                    this.sendBtn(1);
                    return;
                }
                ++this.codeCounter;
            } else {
                this.frogTimer.stop();
                if (this.userFrog.compare(this.problemFrog) && this.chooedPro != -1) {
                    if (this.code.charAt(this.code.length() - 1) == '0') {
                        this.setBtnEnable(false, false, false, false, false, true);
                        this.sendBtn(3);
                    } else {
                        this.setBtnEnable(false, false, false, false, false, true);
                        this.sendBtn(2);
                    }
                } else {
                    this.setBtnEnable(false, false, false, false, false, true);
                    this.sendBtn(0);
                }
            }
        } else if (e.getSource() == this.userTimer) {
            ++this.duration;
        }
    }
}

