/*
 * Decompiled with CFR 0.152.
 */
package frog;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPanel;

class Frog
extends JPanel {
    private int panelWidth;
    private int panelHeight;
    private int xGrid;
    private int yGrid;
    private int gridWidth;
    private int gridHeight;
    private int lineWidth = 3;
    private boolean[][] isDrawn;
    private int[] frogGraphX;
    private int[] frogGraphY;
    private int frogOriX;
    private int frogOriY;
    private int frogX;
    private int frogY;
    private boolean isPenDown;
    private boolean isShow;
    private boolean oriIsShow;
    private byte direct;
    private byte oriDirect;
    public static final byte UP = 0;
    public static final byte RIGHT = 1;
    public static final byte DOWN = 2;
    public static final byte LEFT = 3;
    Color rightColor = new Color(144, 144, 144);
    Color wrongColor = new Color(255, 0, 0);
    Color wantColor = new Color(128, 128, 128);
    Color backColor = new Color(225, 225, 225);

    public Frog(int gridWidth, int gridHeight, int xGrid, int yGrid, boolean isShow) {
        this.gridWidth = gridWidth;
        this.gridHeight = gridHeight;
        this.xGrid = xGrid;
        this.yGrid = yGrid;
        this.isDrawn = new boolean[yGrid][xGrid];
        this.panelWidth = xGrid * gridWidth + this.lineWidth * (xGrid + 3);
        this.panelHeight = yGrid * gridHeight + this.lineWidth * (yGrid + 3);
        this.frogOriX = 0;
        this.frogOriY = 0;
        this.oriIsShow = isShow;
        this.oriDirect = 1;
        this.setFrogGraph();
        this.reset();
    }

    private void setFrogGraph() {
        this.frogGraphX = new int[7];
        this.frogGraphY = new int[7];
        this.frogGraphX[0] = this.gridWidth * 5 / 6;
        this.frogGraphX[1] = this.gridWidth / 2;
        this.frogGraphX[2] = this.gridWidth / 2;
        this.frogGraphX[3] = this.gridWidth / 6;
        this.frogGraphX[4] = this.gridWidth / 6;
        this.frogGraphX[5] = this.gridWidth / 2;
        this.frogGraphX[6] = this.gridWidth / 2;
        this.frogGraphY[0] = this.gridHeight / 2;
        this.frogGraphY[1] = this.gridHeight / 6;
        this.frogGraphY[2] = this.gridHeight / 3;
        this.frogGraphY[3] = this.gridHeight / 3;
        this.frogGraphY[4] = this.gridHeight * 2 / 3;
        this.frogGraphY[5] = this.gridHeight * 2 / 3;
        this.frogGraphY[6] = this.gridHeight * 5 / 6;
    }

    public void reset() {
        this.frogX = this.frogOriX;
        this.frogY = this.frogOriY;
        int y = 0;
        while (y < this.yGrid) {
            int x = 0;
            while (x < this.xGrid) {
                this.isDrawn[y][x] = false;
                ++x;
            }
            ++y;
        }
        this.isPenDown = false;
        this.direct = this.oriDirect;
        this.isShow = this.oriIsShow;
        this.repaint();
    }

    private void paintFrog(Graphics g) {
        Point point = this.getRectOrg(this.frogX, this.frogY);
        point.translate(this.lineWidth, this.lineWidth);
        int[] pX = new int[7];
        int[] pY = new int[7];
        switch (this.direct) {
            case 0: {
                int i = 0;
                while (i < 7) {
                    pX[i] = point.x + this.frogGraphY[i];
                    pY[i] = point.y + this.gridHeight - this.frogGraphX[i];
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < 7) {
                    pX[i] = point.x + this.frogGraphY[i];
                    pY[i] = point.y + this.frogGraphX[i];
                    ++i;
                }
                break;
            }
            case 3: {
                int i = 0;
                while (i < 7) {
                    pX[i] = point.x + this.gridWidth - this.frogGraphX[i];
                    pY[i] = point.y + this.frogGraphY[i];
                    ++i;
                }
                break;
            }
            case 1: {
                int i = 0;
                while (i < 7) {
                    pX[i] = point.x + this.frogGraphX[i];
                    pY[i] = point.y + this.frogGraphY[i];
                    ++i;
                }
                break;
            }
        }
        if (this.isPenDown) {
            g.setColor(Color.black);
            g.fillPolygon(pX, pY, 7);
        } else {
            g.setColor(Color.black);
            g.drawPolygon(pX, pY, 7);
        }
    }

    public void instEND() {
        this.isShow = false;
        this.repaint(this.getRect(this.frogX, this.frogY));
    }

    public void instUP() {
        this.isPenDown = false;
        this.repaint(this.getRect(this.frogX, this.frogY));
    }

    public void instDOWN() {
        this.isPenDown = true;
        this.repaint(this.getRect(this.frogX, this.frogY));
    }

    public void instRTURN() {
        this.direct = (byte)((this.direct + 1) % 4);
        this.repaint(this.getRect(this.frogX, this.frogY));
    }

    public void instLTURN() {
        this.direct = (byte)((this.direct + 3) % 4);
        this.repaint(this.getRect(this.frogX, this.frogY));
    }

    public boolean instJUMP(int step) {
        int tempX = this.frogX;
        int tempY = this.frogY;
        if (step != 0) {
            switch (this.direct) {
                case 0: {
                    if (this.frogY <= 0) {
                        return false;
                    }
                    --this.frogY;
                    break;
                }
                case 1: {
                    if (this.frogX >= this.xGrid - 1) {
                        return false;
                    }
                    ++this.frogX;
                    break;
                }
                case 2: {
                    if (this.frogY >= this.yGrid - 1) {
                        return false;
                    }
                    ++this.frogY;
                    break;
                }
                case 3: {
                    if (this.frogX <= 0) {
                        return false;
                    }
                    --this.frogX;
                }
            }
        }
        if (this.isPenDown) {
            this.isDrawn[this.frogY][this.frogX] = true;
        }
        this.repaint(this.getRect(tempX, tempY));
        this.repaint(this.getRect(this.frogX, this.frogY));
        return true;
    }

    public boolean compare(Frog frog) {
        int y = 0;
        while (y < this.yGrid) {
            int x = 0;
            while (x < this.xGrid) {
                if (this.isDrawn[y][x] != frog.isDrawn[y][x]) {
                    return false;
                }
                ++x;
            }
            ++y;
        }
        return true;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(Color.black);
        g.fillRect(0, 0, this.panelWidth, this.lineWidth);
        int i = 0;
        while (i < this.yGrid + 1) {
            g.fillRect(0, this.getRectOrg((int)0, (int)i).y, this.panelWidth, this.lineWidth);
            ++i;
        }
        g.fillRect(0, this.panelHeight - this.lineWidth, this.panelWidth, this.lineWidth);
        g.fillRect(0, 0, this.lineWidth, this.panelHeight);
        i = 0;
        while (i < this.xGrid + 1) {
            g.fillRect(this.getRectOrg((int)i, (int)0).x, 0, this.lineWidth, this.panelHeight);
            ++i;
        }
        g.fillRect(this.panelWidth - this.lineWidth, 0, this.lineWidth, this.panelHeight);
        int y = 0;
        while (y < this.yGrid) {
            int x = 0;
            while (x < this.xGrid) {
                if (this.isDrawn[y][x]) {
                    g.setColor(this.rightColor);
                } else {
                    g.setColor(this.backColor);
                }
                Rectangle rect = this.getRect(x, y);
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
                ++x;
            }
            ++y;
        }
        if (this.isShow) {
            this.paintFrog(g);
        }
    }

    private Point getRectOrg(int x, int y) {
        return new Point(this.lineWidth + x * (this.gridWidth + this.lineWidth), this.lineWidth + y * (this.gridHeight + this.lineWidth));
    }

    private Rectangle getRect(int x, int y) {
        Point point = this.getRectOrg(x, y);
        return new Rectangle(point.x + this.lineWidth, point.y + this.lineWidth, this.gridWidth, this.gridHeight);
    }
}

