/*
 * Decompiled with CFR 0.152.
 */
package hsv;

import dataTools.Base;
import dataTools.DataTrans;
import hsMaster.Master;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Random;
import javax.swing.JPanel;

class HSV
extends JPanel
implements ActionListener,
AdjustmentListener {
    private String etype;
    private Master master;
    private int hue;
    private int saturation;
    private int value;
    private int guessHue;
    private int guessSaturation;
    private int guessValue;
    private double v1;
    private double v2;
    private double R;
    private int score;
    private long startTime;
    private long timeLength;
    private Button check = new Button("\u770b\u7b54\u6848");
    private boolean isCheck;
    private Color bgcolor = new Color(253, 255, 230);
    private Scrollbar hueSlider = new Scrollbar(0, 25, 0, 0, 360);
    private Scrollbar saturationSlider = new Scrollbar(0, 100, 0, 0, 101);
    private Scrollbar valueSlider = new Scrollbar(0, 100, 0, 0, 101);
    Label HueLabel = new Label(" Hue   ( 0 ~ 359) : " + this.guessHue);
    Label SaturationLabel = new Label(" Saturation ( 0 ~ 100) : " + this.guessSaturation);
    Label ValueLabel = new Label(" Value  ( 0 ~ 100) : " + this.guessValue);
    Font font = new Font("Courier", 0, 14);
    JPanel empty = new JPanel();

    HSV(String etype, Master master) {
        this.etype = etype;
        this.master = master;
        this.decoration();
        this.start();
    }

    private int[] trans(int[] values) {
        double h = values[0];
        double s = (double)values[1] / 100.0;
        double v = (double)values[2] / 100.0;
        int hi = (int)(h / 60.0);
        double f = h / 60.0 - (double)hi;
        double p = v * (1.0 - s);
        double q = v * (1.0 - f * s);
        double t = v * (1.0 - (1.0 - f) * s);
        switch (hi) {
            case 0: {
                values[0] = (int)(v * 255.0);
                values[1] = (int)(t * 255.0);
                values[2] = (int)(p * 255.0);
                break;
            }
            case 1: {
                values[0] = (int)(q * 255.0);
                values[1] = (int)(v * 255.0);
                values[2] = (int)(p * 255.0);
                break;
            }
            case 2: {
                values[0] = (int)(p * 255.0);
                values[1] = (int)(v * 255.0);
                values[2] = (int)(t * 255.0);
                break;
            }
            case 3: {
                values[0] = (int)(p * 255.0);
                values[1] = (int)(q * 255.0);
                values[2] = (int)(v * 255.0);
                break;
            }
            case 4: {
                values[0] = (int)(t * 255.0);
                values[1] = (int)(p * 255.0);
                values[2] = (int)(v * 255.0);
                break;
            }
            case 5: {
                values[0] = (int)(v * 255.0);
                values[1] = (int)(p * 255.0);
                values[2] = (int)(q * 255.0);
            }
        }
        return values;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.bgcolor);
        g.fillRect(0, 0, 500, 400);
        g.setColor(Color.black);
        g.setFont(this.font);
        g.drawString("\u984c \u76ee \u5340\uff1a", 5, 40);
        g.drawString("\u53cd \u61c9 \u5340\uff1a", 255, 40);
        int[] guessValues = new int[]{this.guessHue, this.guessSaturation, this.guessValue};
        guessValues = this.trans(guessValues);
        g.setColor(new Color(guessValues[0], guessValues[1], guessValues[2]));
        g.fillRect(335, 55, 100, 100);
        int[] values = new int[]{this.hue, this.saturation, this.value};
        values = this.trans(values);
        g.setColor(new Color(values[0], values[1], values[2]));
        g.fillRect(35, 55, 100, 100);
        g.setColor(Color.red);
        g.drawString("\u8272\u3000\u76f8\uff1a", 190, 140);
        g.setColor(new Color(0, 100, 0));
        g.drawString("\u98fd\u548c\u5ea6\uff1a", 190, 165);
        g.setColor(Color.blue);
        g.drawString("\u660e\u3000\u5ea6\uff1a", 190, 190);
        if (this.isCheck) {
            g.setColor(Color.black);
            g.drawString(Integer.toString(this.hue), 250, 140);
            g.drawString(Integer.toString(this.saturation), 250, 165);
            g.drawString(Integer.toString(this.value), 250, 190);
            g.setColor(new Color(236, 0, 140));
            g.drawString("\u5f97\u3000\u5206\uff1a", 400, 20);
            g.drawString(Integer.toString(this.score), 460, 20);
        }
    }

    private void start() {
        this.isCheck = false;
        Random rand = new Random();
        this.hue = Math.abs(rand.nextInt()) % 72 * 5;
        this.saturation = Math.abs(rand.nextInt()) % 16 * 5 + 20;
        this.value = Math.abs(rand.nextInt()) % 16 * 5 + 20;
        this.v1 = Math.sqrt(this.hue * this.hue + this.saturation * this.saturation + this.value * this.value);
        this.startTime = System.currentTimeMillis();
        this.guessHue = this.hueSlider.getValue();
        this.guessSaturation = this.saturationSlider.getValue();
        this.guessValue = this.valueSlider.getValue();
        this.HueLabel.setText(" Hue   ( 0 ~ 359) : " + this.guessHue);
        this.SaturationLabel.setText(" Saturation ( 0 ~ 100) : " + this.guessSaturation);
        this.ValueLabel.setText(" Value  ( 0 ~ 100) : " + this.guessValue);
    }

    private void decoration() {
        this.hueSlider.setUnitIncrement(5);
        this.saturationSlider.setUnitIncrement(5);
        this.valueSlider.setUnitIncrement(5);
        this.hueSlider.setBackground(new Color(230, 230, 230));
        this.saturationSlider.setBackground(new Color(230, 230, 230));
        this.valueSlider.setBackground(new Color(230, 230, 230));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 12.0;
        gbc.fill = 0;
        gbc.gridwidth = 0;
        this.add((Component)this.empty, gbc);
        gbc.gridwidth = 10;
        gbc.weightx = 4.0;
        gbc.weighty = 0.5;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 1;
        this.hueSlider.addAdjustmentListener(this);
        this.add((Component)this.hueSlider, gbc);
        gbc.gridwidth = 0;
        gbc.weightx = 0.5;
        this.add((Component)this.HueLabel, gbc);
        this.HueLabel.setBackground(this.bgcolor);
        gbc.gridwidth = 10;
        gbc.weightx = 4.0;
        gbc.fill = 1;
        this.saturationSlider.addAdjustmentListener(this);
        this.add((Component)this.saturationSlider, gbc);
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        this.add((Component)this.SaturationLabel, gbc);
        this.SaturationLabel.setBackground(this.bgcolor);
        gbc.gridwidth = 10;
        gbc.weightx = 4.0;
        gbc.fill = 1;
        this.valueSlider.addAdjustmentListener(this);
        this.add((Component)this.valueSlider, gbc);
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        this.add((Component)this.ValueLabel, gbc);
        this.ValueLabel.setBackground(this.bgcolor);
        gbc.fill = 0;
        gbc.gridwidth = 0;
        this.check.addActionListener(this);
        this.add((Component)this.check, gbc);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getAdjustable().equals(this.hueSlider)) {
            this.guessHue = e.getValue();
            this.HueLabel.setText(" Hue   ( 0 ~ 359) : " + this.guessHue);
        }
        if (e.getAdjustable().equals(this.saturationSlider)) {
            this.guessSaturation = e.getValue();
            this.SaturationLabel.setText(" Saturation ( 0 ~ 100) : " + this.guessSaturation);
        }
        if (e.getAdjustable().equals(this.valueSlider)) {
            this.guessValue = e.getValue();
            this.ValueLabel.setText(" Value  ( 0 ~ 100) : " + this.guessValue);
        }
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.isCheck = true;
        this.check.setVisible(false);
        int[] GValues = new int[]{this.guessHue, this.guessSaturation, this.guessValue};
        int[] RValues = new int[]{this.hue, this.saturation, this.value};
        GValues = this.trans(GValues);
        RValues = this.trans(RValues);
        this.v2 = Math.sqrt(Math.pow(GValues[0] - RValues[0], 2.0) + Math.pow(GValues[1] - RValues[1], 2.0) + Math.pow(GValues[2] - RValues[2], 2.0));
        this.R = this.v1 == 0.0 ? this.v2 : this.v2 / this.v1 * 100.0;
        this.score = (int)Math.max(100.0 - this.R, 0.0);
        this.timeLength = System.currentTimeMillis() - this.startTime;
        this.timeLength /= 1000L;
        try {
            DataTrans dataTrans = new DataTrans("tSumURL");
            dataTrans.connect();
            dataTrans.openOut();
            dataTrans.write("&examCode=T82");
            dataTrans.write("&user=" + Base.user);
            dataTrans.write("&score=" + this.score);
            dataTrans.write("&time=" + this.timeLength);
            dataTrans.POSTfinshOut();
            dataTrans.closeOut();
            dataTrans.openIn();
            System.out.print(dataTrans.getLine());
            dataTrans.closeIn();
        }
        catch (Exception E) {
            System.out.print("Error");
        }
        this.repaint();
    }
}

