/*
 * Decompiled with CFR 0.152.
 */
package line;

import java.awt.Graphics;
import line.SubLine;

public class EchoLine
extends SubLine {
    private String typeMsg;
    private boolean showCaret;

    public EchoLine() {
        this.setBounds(10, 50, 600, 20);
        this.setForeground(typeFG);
        this.setFont(typeFT);
        this.typeMsg = "";
        this.showCaret = false;
    }

    @Override
    public void paintComponent(Graphics g) {
        int posX = 0;
        int posY = 15;
        g.drawString(this.typeMsg, posX, posY);
        posX = this.typeMsg.length() * wordWidth;
        if (this.showCaret) {
            g.drawString("|", posX, posY);
            g.drawString("^", posX, posY - 1);
        }
    }

    public void write(char word) {
        this.typeMsg = String.valueOf(this.typeMsg) + word;
        this.repaint();
    }

    public void delete() {
        this.typeMsg = this.typeMsg.substring(0, this.typeMsg.length() - 1);
        this.repaint();
    }

    public void clearMsg() {
        this.typeMsg = "";
        this.repaint();
    }

    public void showCaret(boolean isShow) {
        this.showCaret = isShow;
        this.repaint();
    }
}

