/*
 * Decompiled with CFR 0.152.
 */
package line;

import java.awt.Graphics;
import line.SubLine;

public class ErrorLine
extends SubLine {
    private int lineLength = 61;
    private int errorCount;
    private int[] errorPos;

    public ErrorLine() {
        this.setBounds(10, 10, 600, 20);
        this.setForeground(errorFG);
        this.errorCount = 0;
        this.errorPos = new int[this.lineLength];
    }

    @Override
    public void paintComponent(Graphics g) {
        int posX = 0;
        int posY = 15;
        int i = 0;
        while (i < this.errorCount) {
            posX = this.errorPos[i] * wordWidth;
            g.drawString("|", posX + 1, posY - 5);
            g.drawString("v", posX, posY);
            ++i;
        }
    }

    public void addError(int pos) {
        this.errorPos[this.errorCount] = pos;
        ++this.errorCount;
        this.repaint();
    }

    public void removeError() {
        --this.errorCount;
        this.repaint();
    }

    public boolean isError(int pos) {
        int i = 0;
        while (i < this.errorCount) {
            if (pos == this.errorPos[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void clearError() {
        this.errorCount = 0;
        this.repaint();
    }
}

