/*
 * Decompiled with CFR 0.152.
 */
package omni;

import dataTools.Base;
import dataTools.DataTrans;
import java.awt.Button;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JPanel;
import omni.OmPage;

class Omni
extends JPanel
implements ActionListener {
    private OmPage oPage;
    private String etype;
    private int score = 0;
    private Panel titlePanel;
    private Label scoreLab;
    private long startTime = 0L;
    private long timeLen = 0L;
    private int amount = 10;
    private Panel[] topicPanel = new Panel[this.amount];
    private int[] topics = new int[this.amount];
    private int[] tType = new int[this.amount];
    private int[] aType = new int[this.amount];
    private int[] flags = new int[this.amount];
    private int[] base = new int[]{2, 8, 10, 16};
    private String[] baseString = new String[]{"\u4e8c\u9032\u4f4d", "\u516b\u9032\u4f4d", "\u5341\u9032\u4f4d", "\u5341\u516d\u9032\u4f4d"};
    private String table = "0123456789ABCDEF";
    private Panel btnPanel;
    private TextField[] input = new TextField[this.amount];
    private Button[] check = new Button[this.amount];
    private Button record;
    private Label message;
    private Button restart;
    private Button close;
    private JButton update = new JButton();

    public Omni(String etype, OmPage oPage) {
        this.etype = etype;
        this.oPage = oPage;
        this.generateTopics();
        this.draw();
        this.startTime = System.currentTimeMillis();
    }

    private void draw() {
        Color bgcolor = new Color(204, 255, 204);
        this.setBackground(bgcolor);
        this.setLayout(new GridLayout(this.amount + 2, 0, 0, 6));
        this.titlePanel = new Panel();
        Label text = new Label("\u5f97\u5206\uff1a");
        text.setFont(new Font("\u65b0\u7d30\u660e\u9ad4", 0, 18));
        this.scoreLab = new Label();
        this.scoreLab.setText(" 0");
        this.scoreLab.setFont(new Font("\u65b0\u7d30\u660e\u9ad4", 0, 18));
        this.scoreLab.setForeground(Color.white);
        Label author = new Label("\u8a08\u7b97\u6a5f\u6982\u8ad616\u8b1b(C)  Copyright 1999     \u7a0b\u5f0f\u66f4\u65b0\uff1a2015.09.20   ");
        author.setFont(new Font("\u65b0\u7d30\u660e\u9ad4", 0, 18));
        this.titlePanel.setLayout(new FlowLayout(0));
        this.titlePanel.setBackground(Color.blue);
        this.titlePanel.setForeground(Color.yellow);
        this.titlePanel.add(author);
        this.titlePanel.add(text);
        this.titlePanel.add(this.scoreLab);
        this.add(this.titlePanel);
        int i = 0;
        while (i < this.amount) {
            this.topicPanel[i] = new Panel();
            this.topicPanel[i].setLayout(new GridLayout(1, 6, 20, 0));
            String number = String.format("\u7b2c %2d \u984c", i + 1);
            this.topicPanel[i].add(new Label(number));
            this.topicPanel[i].add(new Label(this.baseString[this.tType[i]]));
            this.topicPanel[i].add(new Label(String.valueOf(this.transfer(this.topics[i], this.tType[i])) + "  =  "));
            this.topicPanel[i].add(new Label(this.baseString[this.aType[i]]));
            this.input[i] = new TextField("", 8);
            this.topicPanel[i].add(this.input[i]);
            this.check[i] = new Button("\u6bd4\u5c0d\u7b54\u6848");
            this.check[i].setSize(30, 20);
            this.check[i].addActionListener(this);
            this.topicPanel[i].add(this.check[i]);
            this.topicPanel[i].setFont(new Font("\u65b0\u7d30\u660e\u9ad4", 0, 18));
            this.add(this.topicPanel[i]);
            ++i;
        }
        this.btnPanel = new Panel();
        this.btnPanel.setLayout(new FlowLayout(0));
        this.btnPanel.setBackground(Color.blue);
        this.btnPanel.setForeground(Color.black);
        this.record = new Button("\u767b\u8a18\u6210\u7e3e");
        this.record.setFont(new Font("\u65b0\u7d30\u660e\u9ad4", 0, 18));
        this.record.addActionListener(this);
        this.btnPanel.add(this.record);
        this.message = new Label();
        this.message.setFont(new Font("\u65b0\u7d30\u660e\u9ad4", 0, 20));
        this.message.setForeground(Color.blue);
        this.btnPanel.add(this.message);
        this.add(this.btnPanel);
        this.close = new Button("\u95dc\u9589\u8996\u7a97");
        this.close.setFont(new Font("\u65b0\u7d30\u660e\u9ad4", 0, 18));
        this.close.addActionListener(this);
        this.restart = new Button("\u518d\u505a\u4e00\u6b21");
        this.restart.setFont(new Font("\u65b0\u7d30\u660e\u9ad4", 0, 18));
        this.restart.addActionListener(this);
        this.btnPanel.add(this.close);
        this.btnPanel.add(this.restart);
        this.btnPanel.add(this.update);
        this.close.setVisible(false);
        this.restart.setVisible(false);
        this.update.setVisible(false);
    }

    private void generateTopics() {
        Random random = new Random();
        int i = 0;
        while (i < this.amount) {
            this.topics[i] = random.nextInt(256) + 1;
            this.tType[i] = random.nextInt(4);
            this.aType[i] = (this.tType[i] + random.nextInt(3) % 3 + 1) % 4;
            ++i;
        }
    }

    private String transfer(int number, int type) {
        String output = "";
        while (number > 0) {
            output = String.valueOf(this.table.charAt(number % this.base[type])) + output;
            number /= this.base[type];
        }
        return output;
    }

    private void sendGrade() throws Exception {
        this.timeLen = System.currentTimeMillis() - this.startTime;
        this.timeLen /= 1000L;
        DataTrans dataTrans = new DataTrans("tSumURL");
        dataTrans.connect();
        dataTrans.openOut();
        dataTrans.write("&examCode=T01");
        dataTrans.write("&status=W");
        dataTrans.write("&user=" + Base.user);
        dataTrans.write("&type=" + this.etype);
        dataTrans.write("&score=" + Integer.toString(this.score));
        dataTrans.write("&time=" + Long.toString(this.timeLen));
        dataTrans.closeOut();
        dataTrans.POSTfinshOut();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = -1;
        int i = 0;
        while (i < 10) {
            if (e.getSource() == this.check[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (e.getSource() == this.record) {
            index = 10;
        } else if (e.getSource() == this.close) {
            index = 11;
        } else if (e.getSource() == this.restart) {
            index = 12;
        }
        if (index < 10) {
            String keyin = this.input[index].getText();
            while (keyin.startsWith("0")) {
                keyin = keyin.substring(1, keyin.length());
            }
            if (keyin.equalsIgnoreCase(this.transfer(this.topics[index], this.aType[index]))) {
                this.input[index].setText(keyin);
                this.input[index].setEditable(false);
                this.check[index].setVisible(false);
                this.score += 10 - this.flags[index] * 2;
                this.scoreLab.setText("" + this.score);
            } else if (this.flags[index] < 5) {
                int n = index;
                this.flags[n] = this.flags[n] + 1;
                this.input[index].setText("\u932f\u8aa4");
            }
        } else if (index == 10) {
            try {
                this.sendGrade();
                this.message.setText("\u6210\u7e3e\u767b\u9304\u6210\u529f");
            }
            catch (Exception E) {
                this.message.setText("\u6210\u7e3e\u767b\u9304\u5931\u6557");
            }
            this.btnPanel.remove(this.record);
            this.message.setForeground(Color.yellow);
            this.close.setVisible(true);
            this.restart.setVisible(true);
            this.update.setVisible(true);
            this.update.setVisible(false);
            this.repaint();
        } else if (index == 11) {
            this.oPage.close();
        } else if (index == 12) {
            this.oPage.restart();
        }
    }
}

