/*
 * Decompiled with CFR 0.152.
 */
package quizAuth;

import dataTools.Base;
import dataTools.DataTrans;
import frame.Frame;
import frame.Masters;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import quizAuth.ErrorPage;

public class QuizAuth
extends Frame
implements ActionListener {
    private Masters master;
    private String examCode;
    private String user;
    private String title;
    private ErrorPage errorPage;
    private TextField input = new TextField("", 8);
    private JButton btn = new JButton("\u78ba\u5b9a");

    public QuizAuth(Masters master, String examCode, String title) {
        super(300, 200);
        this.master = master;
        this.examCode = examCode;
        this.user = Base.user;
        this.title = title;
        this.decorate();
        char staus = this.checkIsOpen();
        if (staus == 'E') {
            this.setVisible(true);
        } else {
            this.errorPage = new ErrorPage(staus, title);
        }
    }

    private char checkIsOpen() {
        char staus = 'C';
        try {
            DataTrans dataTrans = new DataTrans("tSumURL");
            dataTrans.connect();
            dataTrans.openOut();
            dataTrans.write("&examCode=" + this.examCode);
            dataTrans.write("&status=R");
            dataTrans.write("&user=" + this.user);
            dataTrans.closeOut();
            dataTrans.openIn();
            staus = dataTrans.getLine().charAt(0);
            dataTrans.closeIn();
        }
        catch (Exception e) {
            System.out.print("connect error!");
        }
        return staus;
    }

    private void decorate() {
        this.setTitle(String.valueOf(this.title) + "--\u9a57\u8b49\u6388\u6b0a\u78bc");
        JPanel body = new JPanel();
        JPanel top = new JPanel();
        JPanel middle = new JPanel();
        JPanel bottom = new JPanel();
        body.setBackground(new Color(253, 255, 230));
        body.setLayout(new GridLayout(3, 1, 0, 6));
        top.setOpaque(false);
        JLabel titleLabel = new JLabel("\u8acb\u8f38\u5165\u6388\u6b0a\u78bc");
        titleLabel.setFont(new Font("\u65b0\u7d30\u660e\u9ad4", 1, 25));
        top.add(titleLabel);
        body.add(top);
        middle.setOpaque(false);
        this.input.setFont(new Font("\u65b0\u7d30\u660e\u9ad4", 0, 25));
        middle.add(this.input);
        body.add(middle);
        bottom.setOpaque(false);
        this.btn.setFont(new Font("\u65b0\u7d30\u660e\u9ad4", 0, 20));
        this.btn.addActionListener(this);
        bottom.add(this.btn);
        body.add(bottom);
        this.getContentPane().add(body);
    }

    private char checkAuthkey(String authkey) {
        char staus = 'C';
        try {
            DataTrans dataTrans = new DataTrans("tSumURL");
            dataTrans.connect();
            dataTrans.openOut();
            dataTrans.write("&examCode=" + this.examCode);
            dataTrans.write("&status=A");
            dataTrans.write("&user=" + this.user);
            dataTrans.write("&authkey=" + authkey);
            dataTrans.closeOut();
            dataTrans.openIn();
            staus = dataTrans.getLine().charAt(0);
            dataTrans.closeIn();
        }
        catch (Exception e) {
            System.out.print("connect error!");
        }
        return staus;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String authkey = this.input.getText();
        char staus = this.checkAuthkey(authkey);
        if (staus == 'E') {
            this.master.start();
        } else {
            this.errorPage = new ErrorPage(staus, this.title);
        }
        this.setVisible(false);
    }
}

