/*
 * Decompiled with CFR 0.152.
 */
package rgb;

import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Random;

public class Example
extends Applet
implements ActionListener,
AdjustmentListener {
    int red;
    int green;
    int blue;
    int guess_red;
    int guess_green;
    int guess_blue = 0;
    int score;
    double v1;
    double v2;
    double R;
    long start_time = 0L;
    long end_time = 0L;
    boolean press = false;
    Random rand = new Random();
    GridBagConstraints gbc = new GridBagConstraints();
    Button check = new Button("\u770b \u7b54 \u6848");
    Insets myinset = new Insets(5, 5, 5, 5);
    Scrollbar redSlider = new Scrollbar(0, 0, 0, 0, 256);
    Scrollbar greenSlider = new Scrollbar(0, 0, 0, 0, 256);
    Scrollbar blueSlider = new Scrollbar(0, 0, 0, 0, 256);
    Label redLabel = new Label(" Red   ( 0 ~ 255) : " + this.guess_red);
    Label greenLabel = new Label(" Green ( 0 ~ 255) : " + this.guess_green);
    Label blueLabel = new Label(" Blue  ( 0 ~ 255) : " + this.guess_blue);
    Font f = new Font("Courier", 0, 14);
    String user;
    String etype;
    Panel empty = new Panel();

    @Override
    public void init() {
        this.setSize(500, 400);
        this.redSlider.setUnitIncrement(5);
        this.greenSlider.setUnitIncrement(5);
        this.blueSlider.setUnitIncrement(5);
        this.user = this.getParameter("user");
        this.etype = this.getParameter("etype");
        this.setLayout(new GridBagLayout());
        this.red = Math.abs(this.rand.nextInt()) % 42 * 5;
        this.green = Math.abs(this.rand.nextInt()) % 42 * 5;
        this.blue = Math.abs(this.rand.nextInt()) % 42 * 5;
        this.v1 = Math.sqrt(this.red * this.red + this.green * this.green + this.blue * this.blue);
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 12.0;
        this.gbc.fill = 0;
        this.gbc.gridwidth = 0;
        this.add((Component)this.empty, this.gbc);
        this.gbc.gridwidth = 10;
        this.gbc.weightx = 4.0;
        this.gbc.weighty = 0.5;
        this.gbc.insets = this.myinset;
        this.gbc.fill = 1;
        this.redSlider.addAdjustmentListener(this);
        this.add((Component)this.redSlider, this.gbc);
        this.gbc.gridwidth = 0;
        this.gbc.weightx = 0.5;
        this.add((Component)this.redLabel, this.gbc);
        this.gbc.gridwidth = 10;
        this.gbc.weightx = 4.0;
        this.gbc.fill = 1;
        this.greenSlider.addAdjustmentListener(this);
        this.add((Component)this.greenSlider, this.gbc);
        this.gbc.gridwidth = 0;
        this.gbc.weightx = 1.0;
        this.add((Component)this.greenLabel, this.gbc);
        this.gbc.gridwidth = 10;
        this.gbc.weightx = 4.0;
        this.gbc.fill = 1;
        this.blueSlider.addAdjustmentListener(this);
        this.add((Component)this.blueSlider, this.gbc);
        this.gbc.gridwidth = 0;
        this.gbc.weightx = 1.0;
        this.add((Component)this.blueLabel, this.gbc);
    }

    @Override
    public void start() {
        this.gbc.fill = 0;
        this.gbc.gridwidth = 0;
        this.check.addActionListener(this);
        this.add((Component)this.check, this.gbc);
        this.start_time = System.currentTimeMillis();
        this.guess_red = this.redSlider.getValue();
        this.guess_green = this.greenSlider.getValue();
        this.guess_blue = this.blueSlider.getValue();
        this.redLabel.setText(" Red   ( 0 ~ 255) : " + this.guess_red);
        this.greenLabel.setText(" Green ( 0 ~ 255) : " + this.guess_green);
        this.blueLabel.setText(" Blue  ( 0 ~ 255) : " + this.guess_blue);
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        g.setFont(this.f);
        g.drawString("\u984c \u76ee \u5340\uff1a", 5, 40);
        g.drawString("\u53cd \u61c9 \u5340\uff1a", 255, 40);
        g.setColor(new Color(this.guess_red, this.guess_green, this.guess_blue));
        g.fillRect(335, 55, 100, 100);
        g.setColor(new Color(this.red, this.green, this.blue));
        g.fillRect(35, 55, 100, 100);
        g.setColor(Color.red);
        g.drawString("\u7d05 \u8272\uff1a", 190, 140);
        g.setColor(new Color(0, 100, 0));
        g.drawString("\u7da0 \u8272\uff1a", 190, 165);
        g.setColor(Color.blue);
        g.drawString("\u85cd \u8272\uff1a", 190, 190);
        if (this.press) {
            g.setColor(Color.red);
            g.drawString(Integer.toString(this.red), 250, 140);
            g.setColor(new Color(0, 100, 0));
            g.drawString(Integer.toString(this.green), 250, 165);
            g.setColor(Color.blue);
            g.drawString(Integer.toString(this.blue), 250, 190);
            g.setColor(new Color(236, 0, 140));
            g.drawString("\u5f97 \u5206\uff1a", 400, 20);
            g.drawString(Integer.toString(this.score), 460, 20);
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.press = true;
        this.check.setVisible(false);
        this.v2 = Math.sqrt(Math.pow(this.guess_red - this.red, 2.0) + Math.pow(this.guess_green - this.green, 2.0) + Math.pow(this.guess_blue - this.blue, 2.0));
        this.R = this.v1 == 0.0 ? this.v2 : this.v2 / this.v1 * 100.0;
        this.score = (int)Math.max(100.0 - this.R, 0.0);
        this.end_time = System.currentTimeMillis() - this.start_time;
        this.end_time /= 1000L;
        try {
            Socket s = new Socket("libai.math.ncu.edu.tw", 80);
            BufferedReader in = new BufferedReader(new InputStreamReader(s.getInputStream()));
            PrintWriter out = new PrintWriter(s.getOutputStream());
            out.flush();
            s.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repaint();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent ae) {
        if (ae.getAdjustable().equals(this.redSlider)) {
            this.guess_red = ae.getValue();
            this.redLabel.setText(" Red   ( 0 ~ 255) : " + this.guess_red);
        }
        if (ae.getAdjustable().equals(this.greenSlider)) {
            this.guess_green = ae.getValue();
            this.greenLabel.setText(" Green ( 0 ~ 255) : " + this.guess_green);
        }
        if (ae.getAdjustable().equals(this.blueSlider)) {
            this.guess_blue = ae.getValue();
            this.blueLabel.setText(" Blue  ( 0 ~ 255) : " + this.guess_blue);
        }
        this.repaint();
    }
}

