/*
 * Decompiled with CFR 0.152.
 */
package rgb;

import dataTools.Base;
import dataTools.DataTrans;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Random;
import javax.swing.JPanel;
import rgMaster.Master;

class RGB
extends JPanel
implements ActionListener,
AdjustmentListener {
    private String etype;
    private Master master;
    private int red;
    private int green;
    private int blue;
    private int guessRed;
    private int guessGreen;
    private int guessBlue;
    private double v1;
    private double v2;
    private double R;
    private int score;
    private long startTime;
    private long timeLength;
    private Button check = new Button("\u770b\u7b54\u6848");
    private boolean isCheck;
    private Color bgcolor = new Color(253, 255, 230);
    private Scrollbar redSlider = new Scrollbar(0, 0, 0, 0, 256);
    private Scrollbar greenSlider = new Scrollbar(0, 0, 0, 0, 256);
    private Scrollbar blueSlider = new Scrollbar(0, 0, 0, 0, 256);
    Label redLabel = new Label(" Red   ( 0 ~ 255) : " + this.guessRed);
    Label greenLabel = new Label(" Green ( 0 ~ 255) : " + this.guessGreen);
    Label blueLabel = new Label(" Blue  ( 0 ~ 255) : " + this.guessBlue);
    Font font = new Font("Courier", 0, 14);
    JPanel empty = new JPanel();

    RGB(String etype, Master master) {
        this.etype = etype;
        this.master = master;
        this.decoration();
        this.start();
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.bgcolor);
        g.fillRect(0, 0, 500, 400);
        g.setColor(Color.black);
        g.setFont(this.font);
        g.drawString("\u984c \u76ee \u5340\uff1a", 5, 40);
        g.drawString("\u53cd \u61c9 \u5340\uff1a", 255, 40);
        g.setColor(new Color(this.guessRed, this.guessGreen, this.guessBlue));
        g.fillRect(335, 55, 100, 100);
        g.setColor(new Color(this.red, this.green, this.blue));
        g.fillRect(35, 55, 100, 100);
        g.setColor(Color.red);
        g.drawString("\u7d05 \u8272\uff1a", 190, 140);
        g.setColor(new Color(0, 100, 0));
        g.drawString("\u7da0 \u8272\uff1a", 190, 165);
        g.setColor(Color.blue);
        g.drawString("\u85cd \u8272\uff1a", 190, 190);
        if (this.isCheck) {
            g.setColor(Color.red);
            g.drawString(Integer.toString(this.red), 250, 140);
            g.setColor(new Color(0, 100, 0));
            g.drawString(Integer.toString(this.green), 250, 165);
            g.setColor(Color.blue);
            g.drawString(Integer.toString(this.blue), 250, 190);
            g.setColor(new Color(236, 0, 140));
            g.drawString("\u5f97 \u5206\uff1a", 400, 20);
            g.drawString(Integer.toString(this.score), 460, 20);
        }
    }

    private void start() {
        this.isCheck = false;
        Random rand = new Random();
        this.red = Math.abs(rand.nextInt()) % 42 * 5;
        this.green = Math.abs(rand.nextInt()) % 42 * 5;
        this.blue = Math.abs(rand.nextInt()) % 42 * 5;
        this.v1 = Math.sqrt(this.red * this.red + this.green * this.green + this.blue * this.blue);
        this.startTime = System.currentTimeMillis();
        this.guessRed = this.redSlider.getValue();
        this.guessGreen = this.greenSlider.getValue();
        this.guessBlue = this.blueSlider.getValue();
        this.redLabel.setText(" Red   ( 0 ~ 255) : " + this.guessRed);
        this.greenLabel.setText(" Green ( 0 ~ 255) : " + this.guessGreen);
        this.blueLabel.setText(" Blue  ( 0 ~ 255) : " + this.guessBlue);
    }

    private void decoration() {
        this.redSlider.setUnitIncrement(5);
        this.greenSlider.setUnitIncrement(5);
        this.blueSlider.setUnitIncrement(5);
        this.redSlider.setBackground(new Color(230, 230, 230));
        this.greenSlider.setBackground(new Color(230, 230, 230));
        this.blueSlider.setBackground(new Color(230, 230, 230));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 12.0;
        gbc.fill = 0;
        gbc.gridwidth = 0;
        this.add((Component)this.empty, gbc);
        gbc.gridwidth = 10;
        gbc.weightx = 4.0;
        gbc.weighty = 0.5;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 1;
        this.redSlider.addAdjustmentListener(this);
        this.add((Component)this.redSlider, gbc);
        gbc.gridwidth = 0;
        gbc.weightx = 0.5;
        this.add((Component)this.redLabel, gbc);
        this.redLabel.setBackground(this.bgcolor);
        gbc.gridwidth = 10;
        gbc.weightx = 4.0;
        gbc.fill = 1;
        this.greenSlider.addAdjustmentListener(this);
        this.add((Component)this.greenSlider, gbc);
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        this.add((Component)this.greenLabel, gbc);
        this.greenLabel.setBackground(this.bgcolor);
        gbc.gridwidth = 10;
        gbc.weightx = 4.0;
        gbc.fill = 1;
        this.blueSlider.addAdjustmentListener(this);
        this.add((Component)this.blueSlider, gbc);
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        this.add((Component)this.blueLabel, gbc);
        this.blueLabel.setBackground(this.bgcolor);
        gbc.fill = 0;
        gbc.gridwidth = 0;
        this.check.addActionListener(this);
        this.add((Component)this.check, gbc);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getAdjustable().equals(this.redSlider)) {
            this.guessRed = e.getValue();
            this.redLabel.setText(" Red   ( 0 ~ 255) : " + this.guessRed);
        }
        if (e.getAdjustable().equals(this.greenSlider)) {
            this.guessGreen = e.getValue();
            this.greenLabel.setText(" Green ( 0 ~ 255) : " + this.guessGreen);
        }
        if (e.getAdjustable().equals(this.blueSlider)) {
            this.guessBlue = e.getValue();
            this.blueLabel.setText(" Blue  ( 0 ~ 255) : " + this.guessBlue);
        }
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.isCheck = true;
        this.check.setVisible(false);
        this.v2 = Math.sqrt(Math.pow(this.guessRed - this.red, 2.0) + Math.pow(this.guessGreen - this.green, 2.0) + Math.pow(this.guessBlue - this.blue, 2.0));
        this.R = this.v1 == 0.0 ? this.v2 : this.v2 / this.v1 * 100.0;
        this.score = (int)Math.max(100.0 - this.R, 0.0);
        this.timeLength = System.currentTimeMillis() - this.startTime;
        this.timeLength /= 1000L;
        try {
            DataTrans dataTrans = new DataTrans("tSumURL");
            dataTrans.connect();
            dataTrans.openOut();
            dataTrans.write("&examCode=T81");
            dataTrans.write("&user=" + Base.user);
            dataTrans.write("&score=" + this.score);
            dataTrans.write("&time=" + this.timeLength);
            dataTrans.POSTfinshOut();
            dataTrans.closeOut();
            dataTrans.openIn();
            System.out.print(dataTrans.getLine());
            dataTrans.closeIn();
        }
        catch (Exception E) {
            System.out.print("Error");
        }
        this.repaint();
    }
}

