/*
 * Decompiled with CFR 0.152.
 */
package update;

import dataTools.DataScanner;
import dataTools.DataTrans;
import frame.Frame;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Update
extends Frame
implements ActionListener {
    private String newVerId;
    private String nowVerId;
    private String bccAppName = DataScanner.getAppName();
    private String tempFileName = "temp.jar";
    private JButton Yes;
    private JButton No;

    public Update(String nowVerId) {
        super(500, 150);
        this.nowVerId = nowVerId;
        this.newVerId = this.getNewVerId();
        File tempFile = new File(this.tempFileName);
        if (tempFile.exists()) {
            tempFile.delete();
        }
        if (!this.isVerIdSame()) {
            this.showChoice();
        }
    }

    private void showChoice() {
        this.setTitle("\u66f4\u65b0\u8a0a\u606f");
        Container container = this.getContentPane();
        JPanel table = new JPanel();
        container.add(table);
        table.setLayout(new GridLayout(2, 1, 0, 0));
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new FlowLayout(1));
        JLabel textLabel = new JLabel("\u6709\u66f4\u65b0\u7684\u7248\u672c\uff0c\u662f\u5426\u8981\u66f4\u65b0\uff1f");
        textLabel.setFont(new Font("\u6a19\u6977\u9ad4", 0, 30));
        textPanel.add(textLabel);
        table.add(textPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1));
        this.Yes = new JButton("\u662f");
        this.Yes.setFont(new Font("\u6a19\u6977\u9ad4", 0, 25));
        this.Yes.addActionListener(this);
        this.No = new JButton("\u5426");
        this.No.setFont(new Font("\u6a19\u6977\u9ad4", 0, 25));
        this.No.addActionListener(this);
        buttonPanel.add(this.Yes);
        buttonPanel.add(this.No);
        table.add(buttonPanel);
        this.setVisible(true);
    }

    private boolean isVerIdSame() {
        return this.nowVerId.equals(this.newVerId);
    }

    private String getNewVerId() {
        String newVerId = this.nowVerId;
        try {
            DataTrans dataTrans = new DataTrans("updateCheckURL");
            dataTrans.connect();
            dataTrans.openIn();
            newVerId = dataTrans.getLine();
            dataTrans.closeIn();
        }
        catch (Exception e) {
            System.out.print("connect fail");
        }
        return newVerId;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.Yes) {
            DataScanner.readANDcreateFile("updateDataURL", "updateDataName", this.tempFileName);
            DataScanner.coverFile(this.tempFileName, this.bccAppName);
            this.restart();
        }
        if (e.getSource() == this.No) {
            this.setVisible(false);
        }
    }

    private void restart() {
        Runtime r = Runtime.getRuntime();
        try {
            String command = "java -jar " + this.bccAppName;
            r.exec(command);
            System.exit(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

